/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.specialsource;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import net.md_5.specialsource.CustomRemapper;
import net.md_5.specialsource.Jar;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.NodeType;
import net.md_5.specialsource.RemapperPreprocessor;
import net.md_5.specialsource.RemappingClassAdapter;
import net.md_5.specialsource.SpecialSource;
import net.md_5.specialsource.repo.ClassRepo;
import net.md_5.specialsource.repo.JarRepo;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class JarRemapper
extends CustomRemapper {
    private static final int CLASS_LEN = ".class".length();
    public final JarMapping jarMapping;
    public RemapperPreprocessor remapperPreprocessor;
    private int writerFlags = 1;
    private int readerFlags = 0;
    private boolean copyResources = true;

    public JarRemapper(RemapperPreprocessor remapperPreprocessor, JarMapping jarMapping) {
        this.remapperPreprocessor = remapperPreprocessor;
        this.jarMapping = jarMapping;
    }

    public JarRemapper(JarMapping jarMapping) {
        this(null, jarMapping);
    }

    public void setGenerateAPI(boolean generateAPI) {
        if (generateAPI) {
            this.readerFlags |= 1;
            this.copyResources = false;
        } else {
            this.readerFlags &= 0xFFFFFFFE;
            this.copyResources = true;
        }
    }

    @Override
    public String map(String typeName) {
        return JarRemapper.mapTypeName(typeName, this.jarMapping.packages, this.jarMapping.classes, typeName);
    }

    public static String mapTypeName(String typeName, Map<String, String> packageMap, Map<String, String> classMap, String defaultIfUnmapped) {
        String mapped = JarRemapper.mapClassName(typeName, packageMap, classMap);
        return mapped != null ? mapped : defaultIfUnmapped;
    }

    private static String mapClassName(String className, Map<String, String> packageMap, Map<String, String> classMap) {
        if (classMap != null && classMap.containsKey(className)) {
            return classMap.get(className);
        }
        int index = className.lastIndexOf(36);
        if (index != -1) {
            String outer = className.substring(0, index);
            String mapped = JarRemapper.mapClassName(outer, packageMap, classMap);
            if (mapped == null) {
                return null;
            }
            return mapped + className.substring(index);
        }
        if (packageMap != null) {
            for (String oldPackage : packageMap.keySet()) {
                if (!JarRemapper.matchClassPackage(oldPackage, className)) continue;
                String newPackage = packageMap.get(oldPackage);
                return JarRemapper.moveClassPackage(newPackage, JarRemapper.getSimpleName(oldPackage, className));
            }
        }
        return null;
    }

    private static boolean matchClassPackage(String packageName, String className) {
        if (packageName.equals(".")) {
            return JarRemapper.isDefaultPackage(className);
        }
        return className.startsWith(packageName);
    }

    private static String moveClassPackage(String packageName, String classSimpleName) {
        if (packageName.equals(".")) {
            return classSimpleName;
        }
        return packageName + classSimpleName;
    }

    private static boolean isDefaultPackage(String className) {
        return className.indexOf(47) == -1;
    }

    private static String getSimpleName(String oldPackage, String className) {
        if (oldPackage.equals(".")) {
            return className;
        }
        return className.substring(oldPackage.length());
    }

    @Override
    public String mapFieldName(String owner, String name, String desc, int access) {
        String mapped = this.jarMapping.tryClimb(this.jarMapping.fields, NodeType.FIELD, owner, name, access);
        return mapped == null ? name : mapped;
    }

    @Override
    public String mapMethodName(String owner, String name, String desc, int access) {
        String mapped = this.jarMapping.tryClimb(this.jarMapping.methods, NodeType.METHOD, owner, name + " " + desc, access);
        return mapped == null ? name : mapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remapJar(Jar jar, File target) throws IOException {
        JarOutputStream out = new JarOutputStream(new FileOutputStream(target));
        JarRepo repo = new JarRepo(jar);
        try {
            if (jar == null) {
                return;
            }
            for (String name : jar.getEntryNames()) {
                InputStream is = jar.getResource(name);
                try {
                    JarEntry entry;
                    byte[] data;
                    if (name.endsWith(".class")) {
                        name = name.substring(0, name.length() - CLASS_LEN);
                        data = this.remapClassFile(is, (ClassRepo)repo);
                        String newName = this.map(name);
                        entry = new JarEntry(newName == null ? name : newName + ".class");
                    } else {
                        int n;
                        if (name.endsWith(".DSA") || name.endsWith(".SF") || !this.copyResources) continue;
                        entry = new JarEntry(name);
                        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                        byte[] b = new byte[32768];
                        while ((n = is.read(b, 0, b.length)) != -1) {
                            buffer.write(b, 0, n);
                        }
                        buffer.flush();
                        data = buffer.toByteArray();
                    }
                    entry.setTime(0L);
                    out.putNextEntry(entry);
                    out.write(data);
                }
                finally {
                    is.close();
                }
            }
        }
        finally {
            out.close();
        }
    }

    public byte[] remapClassFile(InputStream is, ClassRepo repo) throws IOException {
        return this.remapClassFile(new ClassReader(is), repo);
    }

    public byte[] remapClassFile(byte[] in, ClassRepo repo) {
        return this.remapClassFile(new ClassReader(in), repo);
    }

    private byte[] remapClassFile(ClassReader reader, ClassRepo repo) {
        byte[] pre;
        if (this.remapperPreprocessor != null && (pre = this.remapperPreprocessor.preprocess(reader)) != null) {
            reader = new ClassReader(pre);
        }
        ClassNode node = new ClassNode();
        RemappingClassAdapter mapper = new RemappingClassAdapter(node, this, repo);
        reader.accept(mapper, this.readerFlags);
        ClassWriter wr = new ClassWriter(this.writerFlags);
        node.accept(wr);
        if (SpecialSource.identifier != null) {
            wr.newUTF8(SpecialSource.identifier);
        }
        return wr.toByteArray();
    }
}

