/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.mmv;

public class McpBotCommand {
    private final BotCommand command;
    private final String srgName;
    private final String newName;
    private final String comment;

    public static BotCommand getCommand(MemberType type, boolean isForced) {
        switch (type) {
            case METHOD: {
                return isForced ? BotCommand.FSM : BotCommand.SM;
            }
            case PARAM: {
                return isForced ? BotCommand.FSP : BotCommand.SP;
            }
        }
        return isForced ? BotCommand.FSF : BotCommand.SF;
    }

    public McpBotCommand(BotCommand command, String srgName, String newName, String comment) {
        this.command = command;
        this.srgName = srgName;
        this.newName = newName;
        this.comment = comment;
    }

    public McpBotCommand(BotCommand command, String srgName, String newName) {
        this(command, srgName, newName, "");
    }

    public static McpBotCommand[] getMcpBotCommands(MemberType type, boolean isForced, boolean isClientOnly, String srgName, String newName, String comment) {
        McpBotCommand[] commands = new McpBotCommand[]{new McpBotCommand(McpBotCommand.getCommand(type, isForced), srgName, newName, comment)};
        return commands;
    }

    public static McpBotCommand[] updateMcpBotCommands(McpBotCommand[] commands, String srgName, String newName, String comment) {
        for (int i = 0; i < commands.length; ++i) {
            commands[i] = new McpBotCommand(commands[i].getCommand(), srgName, newName, comment);
        }
        return commands;
    }

    public BotCommand getCommand() {
        return this.command;
    }

    public String getNewName() {
        return this.newName;
    }

    public String toString() {
        return String.format("!%s %s %s %s", this.command.toString().toLowerCase(), this.srgName, this.newName, this.comment);
    }

    public static enum MemberType {
        FIELD,
        METHOD,
        PARAM;

    }

    public static enum BotCommand {
        SF,
        SM,
        SP,
        FSF,
        FSM,
        FSP;

    }
}

