/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct;

import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.java.decompiler.code.ConstantsUtil;
import org.jetbrains.java.decompiler.code.ExceptionHandler;
import org.jetbrains.java.decompiler.code.ExceptionTable;
import org.jetbrains.java.decompiler.code.FullInstructionSequence;
import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IVariableNameProvider;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMember;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGenericSignatureAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMain;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMethodDescriptor;
import org.jetbrains.java.decompiler.util.DataInputFullStream;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public class StructMethod
extends StructMember {
    private static final int[] opr_iconst = new int[]{-1, 0, 1, 2, 3, 4, 5};
    private static final int[] opr_loadstore = new int[]{0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3};
    private static final int[] opcs_load = new int[]{21, 22, 23, 24, 25};
    private static final int[] opcs_store = new int[]{54, 55, 56, 57, 58};
    private final StructClass classStruct;
    private final String name;
    private final String descriptor;
    private GenericMethodDescriptor signature;
    private boolean containsCode = false;
    private int localVariables = 0;
    private int codeLength = 0;
    private int codeFullLength = 0;
    private InstructionSequence seq;
    private boolean expanded = false;
    private VBStyleCollection<StructGeneralAttribute, String> codeAttributes;
    private IVariableNameProvider renamer;

    public StructMethod(DataInputFullStream in, StructClass clStruct) throws IOException {
        this.classStruct = clStruct;
        this.accessFlags = in.readUnsignedShort();
        int nameIndex = in.readUnsignedShort();
        int descriptorIndex = in.readUnsignedShort();
        ConstantPool pool = clStruct.getPool();
        String[] values = pool.getClassElement(2, clStruct.qualifiedName, nameIndex, descriptorIndex);
        this.name = values[0];
        this.descriptor = values[1];
        this.attributes = this.readAttributes(in, pool);
        if (this.codeAttributes != null) {
            this.attributes.addAllWithKey(this.codeAttributes);
            this.codeAttributes = null;
        }
    }

    @Override
    protected StructGeneralAttribute readAttribute(DataInputFullStream in, ConstantPool pool, String name) throws IOException {
        if ("Code".equals(name)) {
            if (!this.classStruct.isOwn()) {
                in.discard(8);
                in.discard(in.readInt());
                in.discard(8 * in.readUnsignedShort());
            } else {
                this.containsCode = true;
                in.discard(6);
                this.localVariables = in.readUnsignedShort();
                this.codeLength = in.readInt();
                in.discard(this.codeLength);
                int excLength = in.readUnsignedShort();
                in.discard(excLength * 8);
                this.codeFullLength = this.codeLength + excLength * 8 + 2;
            }
            this.codeAttributes = this.readAttributes(in, pool);
            return null;
        }
        StructGeneralAttribute attribute = super.readAttribute(in, pool, name);
        if ("Signature".equals(name) && DecompilerContext.getOption("dgs")) {
            StructGenericSignatureAttribute signature = (StructGenericSignatureAttribute)attribute;
            this.signature = GenericMain.parseMethodSignature(signature.getSignature());
        }
        return attribute;
    }

    public void expandData() throws IOException {
        if (this.containsCode && !this.expanded) {
            byte[] code = this.classStruct.getLoader().loadBytecode(this, this.codeFullLength);
            this.seq = this.parseBytecode(new DataInputFullStream(code), this.codeLength, this.classStruct.getPool());
            this.loadRenamer();
            this.expanded = true;
        }
    }

    private void loadRenamer() {
        if (this.renamer == null) {
            this.renamer = DecompilerContext.getNamingFactory().createFactory(this);
        }
    }

    public void releaseResources() throws IOException {
        if (this.containsCode && this.expanded) {
            this.seq = null;
            this.expanded = false;
        }
    }

    private InstructionSequence parseBytecode(DataInputFullStream in, int length, ConstantPool pool) throws IOException {
        VBStyleCollection<Instruction, Integer> instructions = new VBStyleCollection<Instruction, Integer>();
        int bytecode_version = this.classStruct.getBytecodeVersion();
        for (int i = 0; i < length; ++i) {
            boolean wide;
            int offset = i;
            int opcode = in.readUnsignedByte();
            int group = 1;
            boolean bl = wide = opcode == 196;
            if (wide) {
                ++i;
                opcode = in.readUnsignedByte();
            }
            ArrayList<Integer> operands = new ArrayList<Integer>();
            if (opcode >= 2 && opcode <= 8) {
                operands.add(new Integer(opr_iconst[opcode - 2]));
                opcode = 16;
            } else if (opcode >= 26 && opcode <= 45) {
                operands.add(new Integer(opr_loadstore[opcode - 26]));
                opcode = opcs_load[(opcode - 26) / 4];
            } else if (opcode >= 59 && opcode <= 78) {
                operands.add(new Integer(opr_loadstore[opcode - 59]));
                opcode = opcs_store[(opcode - 59) / 4];
            } else {
                switch (opcode) {
                    case 16: {
                        operands.add(new Integer(in.readByte()));
                        ++i;
                        break;
                    }
                    case 18: 
                    case 188: {
                        operands.add(new Integer(in.readUnsignedByte()));
                        ++i;
                        break;
                    }
                    case 17: 
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 167: 
                    case 168: 
                    case 198: 
                    case 199: {
                        if (opcode != 17) {
                            group = 2;
                        }
                        operands.add(new Integer(in.readShort()));
                        i += 2;
                        break;
                    }
                    case 19: 
                    case 20: 
                    case 178: 
                    case 179: 
                    case 180: 
                    case 181: 
                    case 182: 
                    case 183: 
                    case 184: 
                    case 187: 
                    case 189: 
                    case 192: 
                    case 193: {
                        operands.add(new Integer(in.readUnsignedShort()));
                        i += 2;
                        if (opcode >= 178 && opcode <= 181) {
                            group = 5;
                            break;
                        }
                        if (opcode < 182 || opcode > 184) break;
                        group = 4;
                        break;
                    }
                    case 186: {
                        if (!this.classStruct.isVersionGE_1_7()) break;
                        operands.add(new Integer(in.readUnsignedShort()));
                        in.discard(2);
                        group = 4;
                        i += 4;
                        break;
                    }
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 169: {
                        if (wide) {
                            operands.add(new Integer(in.readUnsignedShort()));
                            i += 2;
                        } else {
                            operands.add(new Integer(in.readUnsignedByte()));
                            ++i;
                        }
                        if (opcode != 169) break;
                        group = 6;
                        break;
                    }
                    case 132: {
                        if (wide) {
                            operands.add(new Integer(in.readUnsignedShort()));
                            operands.add(new Integer(in.readShort()));
                            i += 4;
                            break;
                        }
                        operands.add(new Integer(in.readUnsignedByte()));
                        operands.add(new Integer(in.readByte()));
                        i += 2;
                        break;
                    }
                    case 200: 
                    case 201: {
                        opcode = opcode == 201 ? 168 : 167;
                        operands.add(new Integer(in.readInt()));
                        group = 2;
                        i += 4;
                        break;
                    }
                    case 185: {
                        operands.add(new Integer(in.readUnsignedShort()));
                        operands.add(new Integer(in.readUnsignedByte()));
                        in.discard(1);
                        group = 4;
                        i += 4;
                        break;
                    }
                    case 197: {
                        operands.add(new Integer(in.readUnsignedShort()));
                        operands.add(new Integer(in.readUnsignedByte()));
                        i += 3;
                        break;
                    }
                    case 170: {
                        in.discard((4 - (i + 1) % 4) % 4);
                        i += (4 - (i + 1) % 4) % 4;
                        operands.add(new Integer(in.readInt()));
                        i += 4;
                        int low = in.readInt();
                        operands.add(new Integer(low));
                        i += 4;
                        int high = in.readInt();
                        operands.add(new Integer(high));
                        i += 4;
                        for (int j = 0; j < high - low + 1; ++j) {
                            operands.add(new Integer(in.readInt()));
                            i += 4;
                        }
                        group = 3;
                        break;
                    }
                    case 171: {
                        in.discard((4 - (i + 1) % 4) % 4);
                        i += (4 - (i + 1) % 4) % 4;
                        operands.add(new Integer(in.readInt()));
                        i += 4;
                        int npairs = in.readInt();
                        operands.add(new Integer(npairs));
                        i += 4;
                        for (int j = 0; j < npairs; ++j) {
                            operands.add(new Integer(in.readInt()));
                            i += 4;
                            operands.add(new Integer(in.readInt()));
                            i += 4;
                        }
                        group = 3;
                        break;
                    }
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: 
                    case 191: {
                        group = 6;
                    }
                }
            }
            int[] ops = new int[operands.size()];
            for (int j = 0; j < operands.size(); ++j) {
                ops[j] = (Integer)operands.get(j);
            }
            Instruction instr = ConstantsUtil.getInstructionInstance(opcode, wide, group, bytecode_version, ops);
            instructions.addWithKey(instr, new Integer(offset));
        }
        ArrayList<ExceptionHandler> lstHandlers = new ArrayList<ExceptionHandler>();
        int exception_count = in.readUnsignedShort();
        for (int i = 0; i < exception_count; ++i) {
            int excclass;
            ExceptionHandler handler = new ExceptionHandler();
            handler.from = in.readUnsignedShort();
            handler.to = in.readUnsignedShort();
            handler.handler = in.readUnsignedShort();
            handler.class_index = excclass = in.readUnsignedShort();
            if (excclass != 0) {
                handler.exceptionClass = pool.getPrimitiveConstant(excclass).getString();
            }
            lstHandlers.add(handler);
        }
        FullInstructionSequence seq = new FullInstructionSequence(instructions, new ExceptionTable(lstHandlers));
        int i = seq.length() - 1;
        seq.setPointer(i);
        while (i >= 0) {
            Instruction instr = seq.getInstr(i--);
            if (instr.group != 1) {
                instr.initInstruction(seq);
            }
            seq.addToPointer(-1);
        }
        return seq;
    }

    public StructClass getClassStruct() {
        return this.classStruct;
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public boolean containsCode() {
        return this.containsCode;
    }

    public int getLocalVariables() {
        return this.localVariables;
    }

    public InstructionSequence getInstructionSequence() {
        return this.seq;
    }

    public GenericMethodDescriptor getSignature() {
        return this.signature;
    }

    public IVariableNameProvider getRenamer() {
        this.loadRenamer();
        return this.renamer;
    }

    public void unloadRenamer() {
        this.renamer = null;
    }
}

