/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.util;

import java.util.List;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;

public class ExprentUtil {
    public static boolean isVarReferenced(VarExprent var, Statement stat, VarExprent ... whitelist) {
        if (stat.getExprents() == null) {
            for (Object obj : stat.getSequentialObjects()) {
                if (!(obj instanceof Statement ? ExprentUtil.isVarReferenced(var, (Statement)obj, whitelist) : obj instanceof Exprent && ExprentUtil.isVarReferenced(var, (Exprent)obj, whitelist))) continue;
                return true;
            }
        } else {
            for (Exprent exp : stat.getExprents()) {
                if (!ExprentUtil.isVarReferenced(var, exp, whitelist)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isVarReferenced(VarExprent target, Exprent exp, VarExprent ... whitelist) {
        List<Exprent> lst = exp.getAllExprents(true);
        lst.add(exp);
        for (Exprent ex : lst) {
            VarExprent var;
            if (ex == target || ex.type != 12 || (var = (VarExprent)ex).getIndex() != target.getIndex() || var.getVersion() != target.getVersion()) continue;
            boolean allowed = false;
            for (VarExprent white : whitelist) {
                if (var != white) continue;
                allowed = true;
            }
            if (allowed) continue;
            return true;
        }
        return false;
    }

    public static boolean isVarReadFirst(VarVersionPair var, Statement stat, int index, VarExprent ... whitelist) {
        if (stat.getExprents() == null) {
            List<Object> objs = stat.getSequentialObjects();
            for (int x = index; x < objs.size(); ++x) {
                Object obj = objs.get(x);
                if (!(obj instanceof Statement ? ExprentUtil.isVarReadFirst(var, (Statement)obj, 0, whitelist) : obj instanceof Exprent && ExprentUtil.isVarReadFirst(var, (Exprent)obj, whitelist))) continue;
                return true;
            }
        } else {
            for (int x = index; x < stat.getExprents().size(); ++x) {
                if (!ExprentUtil.isVarReadFirst(var, stat.getExprents().get(x), whitelist)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isVarReadFirst(VarVersionPair target, Exprent exp, VarExprent ... whitelist) {
        AssignmentExprent ass = exp.type == 2 ? (AssignmentExprent)exp : null;
        List<Exprent> lst = exp.getAllExprents(true);
        lst.add(exp);
        for (Exprent ex : lst) {
            VarExprent var;
            if (ex.type != 12 || (var = (VarExprent)ex).getIndex() != target.var || var.getVersion() != target.version) continue;
            boolean allowed = false;
            if (ass != null && var == ass.getLeft()) {
                allowed = true;
            }
            for (VarExprent white : whitelist) {
                if (var != white) continue;
                allowed = true;
            }
            if (allowed) continue;
            return true;
        }
        return false;
    }
}

