/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.TextBuffer;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.consts.LinkConstant;
import org.jetbrains.java.decompiler.struct.gen.FieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchEngine;
import org.jetbrains.java.decompiler.struct.match.MatchNode;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.TextUtil;

public class FieldExprent
extends Exprent {
    private final String name;
    private final String classname;
    private final boolean isStatic;
    private Exprent instance;
    private final FieldDescriptor descriptor;

    public FieldExprent(LinkConstant cn, Exprent instance, BitSet bytecodeOffsets) {
        this(cn.elementname, cn.classname, instance == null, instance, FieldDescriptor.parseDescriptor(cn.descriptor), bytecodeOffsets);
    }

    public FieldExprent(String name, String classname, boolean isStatic, Exprent instance, FieldDescriptor descriptor, BitSet bytecodeOffsets) {
        super(5);
        this.name = name;
        this.classname = classname;
        this.isStatic = isStatic;
        this.instance = instance;
        this.descriptor = descriptor;
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    @Override
    public VarType getExprType() {
        return this.descriptor.type;
    }

    @Override
    public VarType getInferredExprType(VarType upperBound) {
        StructClass cl = DecompilerContext.getStructContext().getClass(this.classname);
        while (cl != null) {
            StructField ft = cl.getField(this.name, this.descriptor.descriptorString);
            if (ft != null && ft.getSignature() != null) {
                return ft.getSignature().type;
            }
            if (cl.superClass == null) {
                cl = null;
                continue;
            }
            cl = DecompilerContext.getStructContext().getClass((String)cl.superClass.value);
        }
        return this.getExprType();
    }

    @Override
    public int getExprentUse() {
        return this.instance == null ? 1 : this.instance.getExprentUse() & 1;
    }

    @Override
    public List<Exprent> getAllExprents() {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        if (this.instance != null) {
            lst.add(this.instance);
        }
        return lst;
    }

    @Override
    public Exprent copy() {
        return new FieldExprent(this.name, this.classname, this.isStatic, this.instance == null ? null : this.instance.copy(), this.descriptor, this.bytecode);
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        TextBuffer buf = new TextBuffer();
        if (this.isStatic) {
            ClassesProcessor.ClassNode node = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
            if (node == null || !this.classname.equals(node.classStruct.qualifiedName)) {
                buf.append(DecompilerContext.getImportCollector().getShortName(ExprProcessor.buildJavaClassName(this.classname)));
                buf.append(".");
            }
        } else {
            String super_qualifier = null;
            if (this.instance != null && this.instance.type == 12) {
                String this_classname;
                VarExprent instVar = (VarExprent)this.instance;
                VarVersionPair pair = new VarVersionPair(instVar);
                MethodWrapper currentMethod = (MethodWrapper)DecompilerContext.getProperty("CURRENT_METHOD_WRAPPER");
                if (currentMethod != null && (this_classname = currentMethod.varproc.getThisVars().get(pair)) != null && !this.classname.equals(this_classname)) {
                    super_qualifier = this_classname;
                }
            }
            if (super_qualifier != null) {
                TextUtil.writeQualifiedSuper(buf, super_qualifier);
            } else {
                TextBuffer buff = new TextBuffer();
                boolean casted = ExprProcessor.getCastedExprent(this.instance, new VarType(8, 0, this.classname), buff, indent, true, tracer);
                String res = buff.toString();
                if (casted || this.instance.getPrecedence() > this.getPrecedence()) {
                    res = "(" + res + ")";
                }
                buf.append(res);
            }
            if (buf.toString().equals("<VAR_NAMELESS_ENCLOSURE>")) {
                buf.setLength(0);
            } else {
                buf.append(".");
            }
        }
        buf.append(this.name);
        tracer.addMapping(this.bytecode);
        return buf;
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        if (oldExpr == this.instance) {
            this.instance = newExpr;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof FieldExprent)) {
            return false;
        }
        FieldExprent ft = (FieldExprent)o;
        return InterpreterUtil.equalObjects(this.name, ft.getName()) && InterpreterUtil.equalObjects(this.classname, ft.getClassname()) && this.isStatic == ft.isStatic() && InterpreterUtil.equalObjects(this.instance, ft.getInstance()) && InterpreterUtil.equalObjects(this.descriptor, ft.getDescriptor());
    }

    public String getClassname() {
        return this.classname;
    }

    public FieldDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Exprent getInstance() {
        return this.instance;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        FieldExprent.measureBytecode(values, this.instance);
        this.measureBytecode(values);
    }

    @Override
    public boolean match(MatchNode matchNode, MatchEngine engine) {
        if (!super.match(matchNode, engine)) {
            return false;
        }
        MatchNode.RuleValue rule = matchNode.getRules().get((Object)IMatchable.MatchProperties.EXPRENT_FIELD_NAME);
        return rule == null || !(rule.isVariable() ? !engine.checkAndSetVariableValue((String)rule.value, this.name) : !rule.value.equals(this.name));
    }
}

