/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.gen;

import org.jetbrains.java.decompiler.struct.gen.NewClassNameBuilder;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public class FieldDescriptor {
    public static final FieldDescriptor INTEGER_DESCRIPTOR = FieldDescriptor.parseDescriptor("Ljava/lang/Integer;");
    public static final FieldDescriptor LONG_DESCRIPTOR = FieldDescriptor.parseDescriptor("Ljava/lang/Long;");
    public static final FieldDescriptor FLOAT_DESCRIPTOR = FieldDescriptor.parseDescriptor("Ljava/lang/Float;");
    public static final FieldDescriptor DOUBLE_DESCRIPTOR = FieldDescriptor.parseDescriptor("Ljava/lang/Double;");
    public final VarType type;
    public final String descriptorString;

    private FieldDescriptor(String descriptor) {
        this.type = new VarType(descriptor);
        this.descriptorString = descriptor;
    }

    public static FieldDescriptor parseDescriptor(String descriptor) {
        return new FieldDescriptor(descriptor);
    }

    public String buildNewDescriptor(NewClassNameBuilder builder) {
        String newClassName;
        if (this.type.type == 8 && (newClassName = builder.buildNewClassname(this.type.value)) != null) {
            return new VarType(this.type.type, this.type.arrayDim, newClassName).toString();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof FieldDescriptor)) {
            return false;
        }
        FieldDescriptor fd = (FieldDescriptor)o;
        return this.type.equals(fd.type);
    }

    public int hashCode() {
        return this.type.hashCode();
    }
}

