/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.mmv;

public class ClassSrgData
implements Comparable<ClassSrgData> {
    private final String obfName;
    private final String srgName;
    private String srgPkgName;
    private final boolean isClientOnly;
    public static SortType sortType = SortType.PKG;

    public ClassSrgData(String obfName, String srgName, String srgPkgName, boolean isClientOnly) {
        this.obfName = obfName;
        this.srgName = srgName;
        this.srgPkgName = srgPkgName;
        this.isClientOnly = isClientOnly;
    }

    public String getObfName() {
        return this.obfName;
    }

    public String getSrgName() {
        return this.srgName;
    }

    public String getSrgPkgName() {
        return this.srgPkgName;
    }

    public ClassSrgData setSrgPkgName(String pkg) {
        this.srgPkgName = pkg;
        return this;
    }

    public boolean isClientOnly() {
        return this.isClientOnly;
    }

    public String getFullyQualifiedSrgName() {
        return this.srgPkgName + "/" + this.srgName;
    }

    @Override
    public int compareTo(ClassSrgData o) {
        if (sortType == SortType.PKG) {
            if (o != null) {
                return this.getFullyQualifiedSrgName().compareTo(o.getFullyQualifiedSrgName());
            }
            return 1;
        }
        if (o != null) {
            if (this.obfName.length() != o.obfName.length()) {
                return this.obfName.length() - o.obfName.length();
            }
            return this.obfName.compareTo(o.obfName);
        }
        return 1;
    }

    public boolean contains(String s) {
        return this.srgName.contains(s) || this.obfName.contains(s) || this.srgPkgName.contains(s);
    }

    public static enum SortType {
        PKG,
        OBF;

    }
}

