/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.mmv;

import bspkrs.mmv.ClassSrgData;
import bspkrs.mmv.CsvData;
import bspkrs.mmv.CsvFile;
import bspkrs.mmv.ExcData;
import bspkrs.mmv.ExcFile;
import bspkrs.mmv.FieldSrgData;
import bspkrs.mmv.McpBotCommand;
import bspkrs.mmv.MemberSrgData;
import bspkrs.mmv.MethodSrgData;
import bspkrs.mmv.ParamCsvData;
import bspkrs.mmv.ParamCsvFile;
import bspkrs.mmv.RemoteZipHandler;
import bspkrs.mmv.SrgFile;
import bspkrs.mmv.StaticMethodsFile;
import bspkrs.mmv.gui.MappingGui;
import immibis.bon.IProgressListener;
import java.io.File;
import java.io.IOException;
import java.security.DigestException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class McpMappingLoader {
    private final File baseDir = new File(new File(System.getProperty("user.home")), ".cache/MCPMappingViewer");
    private final String baseSrgDir = "{mc_ver}";
    private final String baseMappingDir = "{mc_ver}/{channel}_{map_ver}";
    private final String baseMappingUrl = "http://export.mcpbot.bspk.rs/mcp_{channel}/{map_ver}-{mc_ver}/mcp_{channel}-{map_ver}-{mc_ver}.zip";
    private final String baseSrgUrl = "http://export.mcpbot.bspk.rs/mcp/{mc_ver}/mcp-{mc_ver}-srg.zip";
    private final File srgDir;
    private final File mappingDir;
    private final File srgFile;
    private final File excFile;
    private final File staticMethodsFile;
    private SrgFile srgFileData;
    private ExcFile excFileData;
    private StaticMethodsFile staticMethods;
    private CsvFile csvFieldData;
    private CsvFile csvMethodData;
    private ParamCsvFile csvParamData;
    private final MappingGui parentGui;
    private final Map<String, McpBotCommand[]> commandMap = new TreeMap<String, McpBotCommand[]>();
    public final Map<MethodSrgData, CsvData> srgMethodData2CsvData = new TreeMap<MethodSrgData, CsvData>();
    public final Map<FieldSrgData, CsvData> srgFieldData2CsvData = new TreeMap<FieldSrgData, CsvData>();
    public final Map<ExcData, Map<String, ParamCsvData>> excData2MapParamCsvData = new TreeMap<ExcData, Map<String, ParamCsvData>>();

    public McpMappingLoader(MappingGui parentGui, String mappingString, IProgressListener progress) throws IOException, CantLoadMCPMappingException, NoSuchAlgorithmException, DigestException {
        progress.setMax(6);
        progress.set(0);
        this.parentGui = parentGui;
        String[] tokens = mappingString.split("_");
        if (tokens.length < 3) {
            throw new CantLoadMCPMappingException("Invalid mapping string specified.");
        }
        progress.set(0, "Fetching SRG data");
        this.srgDir = this.getSubDirForZip(tokens, "http://export.mcpbot.bspk.rs/mcp/{mc_ver}/mcp-{mc_ver}-srg.zip", "{mc_ver}");
        progress.set(1, "Fetching CSV data");
        this.mappingDir = this.getSubDirForZip(tokens, "http://export.mcpbot.bspk.rs/mcp_{channel}/{map_ver}-{mc_ver}/mcp_{channel}-{map_ver}-{mc_ver}.zip", "{mc_ver}/{channel}_{map_ver}");
        this.srgFile = new File(this.srgDir, "joined.srg");
        this.excFile = new File(this.srgDir, "joined.exc");
        this.staticMethodsFile = new File(this.srgDir, "static_methods.txt");
        if (!this.srgFile.exists()) {
            throw new CantLoadMCPMappingException("Unable to find joined.srg. Your MCP conf folder may be corrupt.");
        }
        if (!this.excFile.exists()) {
            throw new CantLoadMCPMappingException("Unable to find joined.exc. Your MCP conf folder may be corrupt.");
        }
        if (!this.staticMethodsFile.exists()) {
            throw new CantLoadMCPMappingException("Unable to find static_methods.txt. Your MCP conf folder may be corrupt.");
        }
        progress.set(2, "Loading CSV data");
        this.loadCsvMapping();
        progress.set(3, "Loading SRG data");
        this.loadSrgMapping();
        progress.set(4, "Linking SRG data with CSV data");
        this.linkSrgDataToCsvData();
        progress.set(5, "Linking EXC data with CSV data");
        this.linkExcDataToSetParamCsvData();
    }

    private File getSubDirForZip(String[] tokens, String baseZipUrl, String baseSubDir) throws CantLoadMCPMappingException, NoSuchAlgorithmException, DigestException, IOException {
        if (!this.baseDir.exists() && !this.baseDir.mkdirs()) {
            throw new CantLoadMCPMappingException("Application data folder does not exist and cannot be created.");
        }
        File subDir = new File(this.baseDir, this.replaceTokens(baseSubDir, tokens));
        if (!subDir.exists() && !subDir.mkdirs()) {
            throw new CantLoadMCPMappingException("Data folder does not exist and cannot be created.");
        }
        RemoteZipHandler rzh = new RemoteZipHandler(this.replaceTokens(baseZipUrl, tokens), subDir, "SHA1");
        rzh.checkRemoteZip();
        return subDir;
    }

    private String replaceTokens(String s, String[] tokens) {
        return s.replace("{mc_ver}", tokens[0]).replace("{channel}", tokens[1]).replace("{map_ver}", tokens[2]);
    }

    private void loadSrgMapping() throws IOException {
        this.staticMethods = new StaticMethodsFile(this.staticMethodsFile);
        this.excFileData = new ExcFile(this.excFile);
        this.srgFileData = new SrgFile(this.srgFile, this.excFileData, this.staticMethods);
    }

    private void loadCsvMapping() throws IOException {
        this.csvFieldData = new CsvFile(new File(this.mappingDir, "fields.csv"));
        this.csvMethodData = new CsvFile(new File(this.mappingDir, "methods.csv"));
        this.csvParamData = new ParamCsvFile(new File(this.mappingDir, "params.csv"));
    }

    private void linkSrgDataToCsvData() {
        for (Map.Entry<String, MethodSrgData> entry : this.srgFileData.srgMethodName2MethodData.entrySet()) {
            if (!this.srgMethodData2CsvData.containsKey(entry.getValue()) && this.csvMethodData.hasCsvDataForKey(entry.getKey())) {
                this.srgMethodData2CsvData.put(entry.getValue(), this.csvMethodData.getCsvDataForKey(entry.getKey()));
                continue;
            }
            if (!this.srgMethodData2CsvData.containsKey(entry.getValue())) continue;
            System.out.println("SRG method " + entry.getKey() + " has multiple entries in CSV file!");
        }
        for (Map.Entry<String, MemberSrgData> entry : this.srgFileData.srgFieldName2FieldData.entrySet()) {
            if (!this.srgFieldData2CsvData.containsKey(entry.getValue()) && this.csvFieldData.hasCsvDataForKey(entry.getKey())) {
                this.srgFieldData2CsvData.put((FieldSrgData)entry.getValue(), this.csvFieldData.getCsvDataForKey(entry.getKey()));
                continue;
            }
            if (!this.srgFieldData2CsvData.containsKey(entry.getValue())) continue;
            System.out.println("SRG field " + entry.getKey() + " has multiple entries in CSV file!");
        }
    }

    private void linkExcDataToSetParamCsvData() {
        for (Map.Entry<String, ExcData> excData : this.excFileData.srgMethodName2ExcData.entrySet()) {
            if (!this.excData2MapParamCsvData.containsKey(excData.getValue()) && excData.getValue().getParameters().length > 0) {
                TreeMap<String, ParamCsvData> params = new TreeMap<String, ParamCsvData>();
                for (String srgName : excData.getValue().getParameters()) {
                    if (!this.csvParamData.hasCsvDataForKey(srgName)) continue;
                    params.put(srgName, this.csvParamData.getCsvDataForKey(srgName));
                }
                this.excData2MapParamCsvData.put(excData.getValue(), params);
                continue;
            }
            if (!this.excData2MapParamCsvData.containsKey(excData.getValue())) continue;
            System.out.println("EXC method param " + excData.getKey() + " has multiple entries in CSV file!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CsvData processMemberDataEdit(McpBotCommand.MemberType type, Map<String, ? extends MemberSrgData> srg2MemberData, Map<? extends MemberSrgData, CsvData> memberData2CsvData, String srgName, String mcpName, String comment) {
        MemberSrgData memberData = srg2MemberData.get(srgName);
        CsvData csvData = null;
        if (memberData == null) return csvData;
        boolean isForced = memberData2CsvData.containsKey(memberData);
        if (isForced) {
            csvData = memberData2CsvData.get(memberData);
            if (mcpName.trim().equals(csvData.getMcpName()) && comment.trim().equals(csvData.getComment())) return null;
            csvData.setMcpName(mcpName.trim());
            csvData.setComment(comment.trim());
        } else {
            csvData = new CsvData(srgName, mcpName.trim(), 2, comment.trim());
        }
        McpBotCommand[] commands = !this.commandMap.containsKey(srgName) ? McpBotCommand.getMcpBotCommands(type, isForced, memberData.isClientOnly(), csvData.getSrgName(), csvData.getMcpName(), csvData.getComment()) : McpBotCommand.updateMcpBotCommands(this.commandMap.get(srgName), csvData.getSrgName(), csvData.getMcpName(), csvData.getComment());
        this.commandMap.put(srgName, commands);
        return csvData;
    }

    public String getBotCommands(boolean clear) {
        String r = "";
        for (McpBotCommand[] commands : this.commandMap.values()) {
            for (McpBotCommand command : commands) {
                r = r + command.toString() + "\n";
            }
        }
        if (clear) {
            this.commandMap.clear();
        }
        return r;
    }

    public boolean hasPendingCommands() {
        return !this.commandMap.isEmpty();
    }

    public TableModel getSearchResults(String input, IProgressListener progress) {
        CsvData csv;
        if (input == null || input.trim().isEmpty()) {
            return this.getClassModel();
        }
        if (progress != null) {
            progress.setMax(3);
            progress.set(0);
        }
        TreeSet<ClassSrgData> results = new TreeSet<ClassSrgData>();
        for (ClassSrgData classSrgData : this.srgFileData.srgClassName2ClassData.values()) {
            if (!classSrgData.contains(input)) continue;
            results.add(classSrgData);
        }
        if (progress != null) {
            progress.set(1);
        }
        block1: for (Map.Entry entry : this.srgFileData.class2MethodDataSet.entrySet()) {
            if (results.contains(entry.getKey())) continue;
            for (MethodSrgData methodData : (Set)entry.getValue()) {
                csv = this.srgMethodData2CsvData.get(methodData);
                if (!methodData.contains(input) && (csv == null || !csv.contains(input))) continue;
                results.add((ClassSrgData)entry.getKey());
                continue block1;
            }
        }
        if (progress != null) {
            progress.set(2);
        }
        block3: for (Map.Entry entry : this.srgFileData.class2FieldDataSet.entrySet()) {
            if (results.contains(entry.getKey())) continue;
            for (FieldSrgData fieldData : (Set)entry.getValue()) {
                csv = this.srgFieldData2CsvData.get(fieldData);
                if (!fieldData.contains(input) && (csv == null || !csv.contains(input))) continue;
                results.add((ClassSrgData)entry.getKey());
                continue block3;
            }
        }
        return new ClassModel(results);
    }

    public TableModel getClassModel() {
        return new ClassModel(this.srgFileData.srgClassName2ClassData.values());
    }

    public TableModel getMethodModel(String srgPkgAndOwner) {
        ClassSrgData classData = this.srgFileData.srgClassName2ClassData.get(srgPkgAndOwner);
        return new MethodModel(this.srgFileData.class2MethodDataSet.get(classData));
    }

    public TableModel getParamModel(String srgMethodName) {
        if (this.excFileData.srgMethodName2ExcData.containsKey(srgMethodName)) {
            return new ParamModel(this.excFileData.srgMethodName2ExcData.get(srgMethodName));
        }
        return MappingGui.paramsDefaultModel;
    }

    public TableModel getFieldModel(String srgPkgAndOwner) {
        ClassSrgData classData = this.srgFileData.srgClassName2ClassData.get(srgPkgAndOwner);
        return new FieldModel(this.srgFileData.class2FieldDataSet.get(classData));
    }

    public class FieldModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] columnNames = new String[]{"MCP Name", "SRG Name", "Obf Name", "Comment"};
        private final Class[] columnTypes = new Class[]{String.class, String.class, String.class, String.class};
        private final boolean[] isColumnEditable = new boolean[]{true, false, false, true};
        private final Object[][] data;
        private final Set<FieldSrgData> setRef;

        public FieldModel(Set<FieldSrgData> srgFieldSet) {
            this.setRef = srgFieldSet;
            this.data = new Object[this.setRef.size()][this.columnNames.length];
            int i = 0;
            for (FieldSrgData fieldData : this.setRef) {
                CsvData csvData = McpMappingLoader.this.srgFieldData2CsvData.get(fieldData);
                if (csvData != null) {
                    this.data[i][0] = csvData.getMcpName();
                    this.data[i][3] = csvData.getComment();
                } else {
                    this.data[i][0] = "";
                    this.data[i][3] = "";
                }
                this.data[i][1] = fieldData.getSrgName();
                this.data[i][2] = fieldData.getObfName();
                ++i;
            }
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex < this.columnNames.length && columnIndex >= 0) {
                return this.columnNames[columnIndex];
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex < this.columnTypes.length && columnIndex >= 0) {
                return this.columnTypes[columnIndex];
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex < this.isColumnEditable.length && columnIndex >= 0) {
                return this.isColumnEditable[columnIndex];
            }
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data[rowIndex][Math.min(columnIndex, this.data[rowIndex].length - 1)];
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.data[rowIndex][columnIndex] = aValue;
            if (columnIndex == 3 && aValue != null && (this.data[rowIndex][0] == null || this.data[rowIndex][0].toString().trim().isEmpty())) {
                return;
            }
            String srgName = (String)this.data[rowIndex][1];
            String mcpName = (String)this.data[rowIndex][0];
            String comment = (String)this.data[rowIndex][3];
            if (mcpName.trim().isEmpty()) {
                return;
            }
            CsvData result = McpMappingLoader.this.processMemberDataEdit(McpBotCommand.MemberType.FIELD, ((McpMappingLoader)McpMappingLoader.this).srgFileData.srgFieldName2FieldData, McpMappingLoader.this.srgFieldData2CsvData, srgName, mcpName, comment);
            if (result != null) {
                McpMappingLoader.this.csvFieldData.updateCsvDataForKey(srgName, result);
                McpMappingLoader.this.srgFieldData2CsvData.put(((McpMappingLoader)McpMappingLoader.this).srgFileData.srgFieldName2FieldData.get(srgName), result);
                McpMappingLoader.this.parentGui.setCsvFileEdited(true);
            }
        }
    }

    public class ParamModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] columnNames = new String[]{"MCP Name", "SRG Name", "Type"};
        private final Class[] columnTypes = new Class[]{String.class, String.class, String.class};
        private final boolean[] isColumnEditable = new boolean[]{true, false, false};
        private final Object[][] data;

        public ParamModel(ExcData excData) {
            this.data = new Object[excData.getParameters().length][this.columnNames.length];
            for (int i = 0; i < excData.getParameters().length; ++i) {
                this.data[i][0] = McpMappingLoader.this.excData2MapParamCsvData.containsKey(excData) && McpMappingLoader.this.excData2MapParamCsvData.get(excData).containsKey(excData.getParameters()[i]) ? McpMappingLoader.this.excData2MapParamCsvData.get(excData).get(excData.getParameters()[i]).getMcpName() : "";
                this.data[i][1] = excData.getParameters()[i];
                this.data[i][2] = excData.getParamTypes()[i];
            }
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex < this.columnNames.length && columnIndex >= 0) {
                return this.columnNames[columnIndex];
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex < this.columnTypes.length && columnIndex >= 0) {
                return this.columnTypes[columnIndex];
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex < this.isColumnEditable.length && columnIndex >= 0) {
                return this.isColumnEditable[columnIndex];
            }
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data[rowIndex][Math.min(columnIndex, this.data[rowIndex].length - 1)];
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.data[rowIndex][columnIndex] = aValue;
            String srgName = (String)this.data[rowIndex][1];
            String mcpName = (String)this.data[rowIndex][0];
            if (mcpName.trim().isEmpty()) {
                return;
            }
            ExcData excData = ((McpMappingLoader)McpMappingLoader.this).excFileData.srgParamName2ExcData.get(srgName);
            ParamCsvData csvData = null;
            if (McpMappingLoader.this.csvParamData.hasCsvDataForKey(srgName)) {
                csvData = McpMappingLoader.this.csvParamData.getCsvDataForKey(srgName);
                if (mcpName.trim().equals(csvData.getMcpName())) return;
                csvData.setMcpName(mcpName.trim());
            } else {
                csvData = new ParamCsvData(srgName, mcpName, 2);
                McpMappingLoader.this.excData2MapParamCsvData.get(excData).put(srgName, csvData);
            }
            McpMappingLoader.this.csvParamData.updateCsvDataForKey(srgName, csvData);
            McpMappingLoader.this.parentGui.setCsvFileEdited(true);
        }
    }

    public class MethodModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] columnNames = new String[]{"MCP Name", "SRG Name", "Obf Name", "SRG Descriptor", "Comment"};
        private final Class[] columnTypes = new Class[]{String.class, String.class, String.class, String.class, String.class};
        private final boolean[] isColumnEditable = new boolean[]{true, false, false, false, true};
        private final Object[][] data;
        private final Set<MethodSrgData> setRef;

        public MethodModel(Set<MethodSrgData> srgMethodSet) {
            this.setRef = srgMethodSet;
            this.data = new Object[this.setRef.size()][this.columnNames.length];
            int i = 0;
            for (MethodSrgData methodData : this.setRef) {
                CsvData csvData = McpMappingLoader.this.srgMethodData2CsvData.get(methodData);
                if (csvData != null) {
                    this.data[i][0] = csvData.getMcpName();
                    this.data[i][4] = csvData.getComment();
                } else {
                    this.data[i][0] = "";
                    this.data[i][4] = "";
                }
                this.data[i][1] = methodData.getSrgName();
                this.data[i][2] = methodData.getObfName();
                this.data[i][3] = methodData.getSrgDescriptor();
                ++i;
            }
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex < this.columnNames.length && columnIndex >= 0) {
                return this.columnNames[columnIndex];
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex < this.columnTypes.length && columnIndex >= 0) {
                return this.columnTypes[columnIndex];
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex < this.isColumnEditable.length && columnIndex >= 0) {
                return this.isColumnEditable[columnIndex];
            }
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data[rowIndex][Math.min(columnIndex, this.data[rowIndex].length - 1)];
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.data[rowIndex][columnIndex] = aValue;
            if (columnIndex == 4 && aValue != null && (this.data[rowIndex][0] == null || this.data[rowIndex][0].toString().trim().isEmpty())) {
                return;
            }
            String srgName = (String)this.data[rowIndex][1];
            String mcpName = (String)this.data[rowIndex][0];
            String comment = (String)this.data[rowIndex][4];
            if (mcpName.trim().isEmpty()) {
                return;
            }
            CsvData result = McpMappingLoader.this.processMemberDataEdit(McpBotCommand.MemberType.METHOD, ((McpMappingLoader)McpMappingLoader.this).srgFileData.srgMethodName2MethodData, McpMappingLoader.this.srgMethodData2CsvData, srgName, mcpName, comment);
            if (result != null) {
                McpMappingLoader.this.csvMethodData.updateCsvDataForKey(srgName, result);
                McpMappingLoader.this.srgMethodData2CsvData.put(((McpMappingLoader)McpMappingLoader.this).srgFileData.srgMethodName2MethodData.get(srgName), result);
                McpMappingLoader.this.parentGui.setCsvFileEdited(true);
            }
        }
    }

    public class ClassModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public final String[] columnNames = new String[]{"Pkg name", "SRG name", "Obf name"};
        private final Class[] columnTypes = new Class[]{String.class, String.class, String.class};
        private final boolean[] isColumnEditable = new boolean[]{false, false, false};
        private final Object[][] data;
        private final Collection<ClassSrgData> collectionRef;

        public ClassModel(Collection<ClassSrgData> map) {
            this.collectionRef = map;
            this.data = new Object[this.collectionRef.size()][this.columnNames.length];
            int i = 0;
            for (ClassSrgData classData : this.collectionRef) {
                this.data[i][0] = classData.getSrgPkgName();
                this.data[i][1] = classData.getSrgName();
                this.data[i][2] = classData.getObfName();
                ++i;
            }
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex < this.columnNames.length && columnIndex >= 0) {
                return this.columnNames[columnIndex];
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex < this.columnTypes.length && columnIndex >= 0) {
                return this.columnTypes[columnIndex];
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex < this.isColumnEditable.length && columnIndex >= 0) {
                return this.isColumnEditable[columnIndex];
            }
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data[rowIndex][Math.min(columnIndex, this.data[rowIndex].length - 1)];
        }
    }

    public static class CantLoadMCPMappingException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public CantLoadMCPMappingException(String reason) {
            super(reason);
        }
    }
}

