/*
 * Decompiled with CFR 0.152.
 */
package com.rl.obf;

import com.rl.NameProvider;
import com.rl.obf.Cl;
import com.rl.obf.ClassTree;
import com.rl.obf.RGSException;
import com.rl.obf.RgsEntry;
import com.rl.obf.RgsEntryType;
import com.rl.obf.RgsEnum;
import com.rl.obf.Version;
import com.rl.obf.classfile.ClassConstants;
import com.rl.obf.classfile.ClassFile;
import com.rl.obf.classfile.ClassFileException;
import com.rl.util.Tools;
import com.rl.util.rfc822.Header;
import com.rl.util.rfc822.Section;
import com.rl.util.rfc822.SectionList;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class GuardDB
implements ClassConstants {
    private static final String STREAM_NAME_MANIFEST = "META-INF/MANIFEST.MF";
    private static final String MANIFEST_VERSION_TAG = "Manifest-Version";
    private static final String MANIFEST_VERSION_VALUE = "1.0";
    private static final String MANIFEST_NAME_TAG = "Name";
    private static final String MANIFEST_DIGESTALG_TAG = "Digest-Algorithms";
    private static final String CLASS_EXT = ".class";
    private static final String SIGNATURE_PREFIX = "META-INF/";
    private static final String SIGNATURE_EXT = ".SF";
    private static final String LOG_MEMORY_USED = "# Memory in use after class data structure built: ";
    private static final String LOG_MEMORY_TOTAL = "# Total memory available                        : ";
    private static final String LOG_MEMORY_BYTES = " bytes";
    private static final String WARNING_SCRIPT_ENTRY_ABSENT = "# WARNING - identifier from script file not found in JAR: ";
    private static final String ERROR_CORRUPT_CLASS = "# ERROR - corrupt class file: ";
    private static final String WARNING_INCOMPATIBLE_VERSION_1 = "# WARNING - class file format has incompatible major-version number: v";
    private static final String WARNING_INCOMPATIBLE_VERSION_2 = "# WARNING - this version of RetroGuard supports up to class format:  v";
    private ZipFile inJar;
    private SectionList oldManifest;
    private SectionList newManifest;
    private ClassTree classTree;
    private boolean hasMap = false;
    private boolean enableMapClassString = false;
    private boolean enableDigestSHA = false;
    private boolean enableDigestMD5 = false;

    public GuardDB(File inFile) throws IOException {
        this.inJar = new ZipFile(inFile);
        this.parseManifest();
    }

    protected void finalize() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildClassTree(PrintWriter log) throws IOException, ClassFileException {
        int incompatibleVersion = 0;
        this.classTree = new ClassTree();
        Enumeration<? extends ZipEntry> entries = this.inJar.entries();
        while (entries.hasMoreElements()) {
            ZipEntry inEntry = entries.nextElement();
            String name = inEntry.getName();
            if (name.length() <= CLASS_EXT.length() || !name.substring(name.length() - CLASS_EXT.length(), name.length()).equals(CLASS_EXT)) continue;
            DataInputStream inStream = new DataInputStream(new BufferedInputStream(this.inJar.getInputStream(inEntry)));
            ClassFile cf = null;
            try {
                cf = ClassFile.create(inStream);
            }
            catch (ClassFileException e) {
                log.println(ERROR_CORRUPT_CLASS + name + " (" + (e.getMessage() != null ? e.getMessage() : "") + ")");
                System.err.println(ERROR_CORRUPT_CLASS + name + " (" + (e.getMessage() != null ? e.getMessage() : "") + ")");
            }
            finally {
                inStream.close();
            }
            if (cf == null) continue;
            if (cf.hasIncompatibleVersion()) {
                incompatibleVersion = cf.getMajorVersion();
            }
            this.classTree.addClassFile(cf);
        }
        if (incompatibleVersion != 0) {
            log.println(WARNING_INCOMPATIBLE_VERSION_1 + incompatibleVersion);
            log.println("# WARNING - this version of RetroGuard supports up to class format:  v50");
        }
    }

    public void retain(RgsEnum rgsIter, PrintWriter log) throws IOException, ClassFileException, RGSException {
        if (this.classTree == null || this.hasMap) {
            this.hasMap = false;
            this.buildClassTree(log);
        }
        try {
            this.classTree.retainMethod("**", "*", true, null, false, 256, 256);
            this.classTree.retainMethod("**/values", "*", false, "java/lang/Enum", false, 25, 25);
            this.classTree.retainMethod("**/valueOf", "*", false, "java/lang/Enum", false, 9, 9);
        }
        catch (ClassFileException classFileException) {
            // empty catch block
        }
        block18: while (rgsIter.hasNext()) {
            RgsEntry entry = rgsIter.next();
            try {
                switch (entry.type) {
                    case OPTION: {
                        if ("DigestSHA".equals(entry.name)) {
                            this.enableDigestSHA = true;
                        } else if ("DigestMD5".equals(entry.name)) {
                            this.enableDigestMD5 = true;
                        } else if ("MapClassString".equals(entry.name)) {
                            this.enableMapClassString = true;
                        } else if (!"Repackage".equals(entry.name)) {
                            if ("Generic".equals(entry.name)) {
                                this.classTree.retainAttribute("Signature");
                            } else if ("LineNumberDebug".equals(entry.name)) {
                                this.classTree.retainAttribute("LineNumberTable");
                                this.classTree.retainAttribute("SourceFile");
                            } else if ("RuntimeAnnotations".equals(entry.name)) {
                                this.classTree.retainAttribute("RuntimeVisibleAnnotations");
                                this.classTree.retainAttribute("RuntimeVisibleParameterAnnotations");
                                this.classTree.retainAttribute("AnnotationDefault");
                            } else if ("Annotations".equals(entry.name)) {
                                this.classTree.retainAttribute("RuntimeVisibleAnnotations");
                                this.classTree.retainAttribute("RuntimeInvisibleAnnotations");
                                this.classTree.retainAttribute("RuntimeVisibleParameterAnnotations");
                                this.classTree.retainAttribute("RuntimeInvisibleParameterAnnotations");
                                this.classTree.retainAttribute("AnnotationDefault");
                            } else if ("Enumeration".equals(entry.name)) {
                                this.classTree.retainClass("**", true, false, false, false, false, "java/lang/Enum", false, 0, 0);
                            } else if ("Application".equals(entry.name)) {
                                this.classTree.retainMethod("**/main", "([Ljava/lang/String;)V", true, null, false, 0, 0);
                            } else if ("Applet".equals(entry.name)) {
                                this.classTree.retainClass("**", false, false, false, false, false, "java/applet/Applet", false, 0, 0);
                            } else if ("RMI".equals(entry.name)) {
                                this.classTree.retainClass("**", false, true, false, false, false, "java/rmi/Remote", false, 0, 0);
                                this.classTree.retainClass("**_Stub", false, false, false, false, false, null, false, 0, 0);
                                this.classTree.retainClass("**_Skel", false, false, false, false, false, null, false, 0, 0);
                            }
                        }
                        if (!"Serializable".equals(entry.name) && !"RMI".equals(entry.name)) continue block18;
                        this.classTree.retainMethod("**/writeObject", "(Ljava/io/ObjectOutputStream;)V", false, "java/io/Serializable", false, 2, 2);
                        this.classTree.retainMethod("**/readObject", "(Ljava/io/ObjectInputStream;)V", false, "java/io/Serializable", false, 2, 2);
                        this.classTree.retainMethod("**/writeReplace", "()Ljava/lang/Object;", false, "java/io/Serializable", false, 0, 0);
                        this.classTree.retainMethod("**/readResolve", "()Ljava/lang/Object;", false, "java/io/Serializable", false, 0, 0);
                        this.classTree.retainField("**/serialVersionUID", "J", false, "java/io/Serializable", false, 24, 24);
                        this.classTree.retainField("**/serialPersistentFields", "[Ljava/io/ObjectStreamField;", false, "java/io/Serializable", false, 26, 26);
                        this.classTree.retainClass("**", false, false, false, false, false, "java/io/Serializable", false, 0, 0);
                        this.classTree.retainField("**", "*", false, "java/io/Serializable", false, 136, 0);
                        break;
                    }
                    case ATTR: {
                        this.classTree.retainAttribute(entry.name);
                        break;
                    }
                    case NOWARN: {
                        this.classTree.noWarnClass(entry.name);
                        break;
                    }
                    case CLASS: 
                    case NOT_CLASS: {
                        this.classTree.retainClass(entry.name, entry.retainToPublic, entry.retainToProtected, entry.retainPubProtOnly, entry.retainFieldsOnly, entry.retainMethodsOnly, entry.extendsName, entry.type == RgsEntryType.NOT_CLASS, entry.accessMask, entry.accessSetting);
                        break;
                    }
                    case METHOD: 
                    case NOT_METHOD: {
                        this.classTree.retainMethod(entry.name, entry.descriptor, entry.retainAndClass, entry.extendsName, entry.type == RgsEntryType.NOT_METHOD, entry.accessMask, entry.accessSetting);
                        break;
                    }
                    case FIELD: 
                    case NOT_FIELD: {
                        this.classTree.retainField(entry.name, entry.descriptor, entry.retainAndClass, entry.extendsName, entry.type == RgsEntryType.NOT_FIELD, entry.accessMask, entry.accessSetting);
                        break;
                    }
                    case PACKAGE_MAP: {
                        this.classTree.retainPackageMap(entry.name, entry.obfName);
                        break;
                    }
                    case REPACKAGE_MAP: {
                        this.classTree.retainRepackageMap(entry.name, entry.obfName);
                        break;
                    }
                    case CLASS_MAP: {
                        this.classTree.retainClassMap(entry.name, entry.obfName);
                        break;
                    }
                    case METHOD_MAP: {
                        this.classTree.retainMethodMap(entry.name, entry.descriptor, entry.obfName);
                        break;
                    }
                    case FIELD_MAP: {
                        this.classTree.retainFieldMap(entry.name, entry.obfName);
                        break;
                    }
                    default: {
                        throw new RGSException("Illegal type received from the .rgs script");
                    }
                }
            }
            catch (ClassFileException e) {
                log.println(WARNING_SCRIPT_ENTRY_ABSENT + entry.name + " (" + (e.getMessage() != null ? e.getMessage() : "") + ")");
                System.err.println(WARNING_SCRIPT_ENTRY_ABSENT + entry.name + " (" + (e.getMessage() != null ? e.getMessage() : "") + ")");
            }
            catch (RGSException e) {
                log.println(WARNING_SCRIPT_ENTRY_ABSENT + entry.name + " (" + (e.getMessage() != null ? e.getMessage() : "") + ")");
                System.err.println(WARNING_SCRIPT_ENTRY_ABSENT + entry.name + " (" + (e.getMessage() != null ? e.getMessage() : "") + ")");
            }
        }
        NameProvider.retainFromSRG(this.classTree);
    }

    public void logWarnings(PrintWriter log) {
        if (this.classTree != null) {
            this.classTree.logWarnings(log);
        }
    }

    public void createMap(PrintWriter log) throws IOException, ClassFileException {
        if (this.classTree == null) {
            this.buildClassTree(log);
        }
        this.classTree.generateNames();
        this.classTree.resolveClasses();
        this.hasMap = true;
        Runtime rt = Runtime.getRuntime();
        rt.gc();
        log.println("#");
        log.println(LOG_MEMORY_USED + Long.toString(rt.totalMemory() - rt.freeMemory()) + LOG_MEMORY_BYTES);
        log.println(LOG_MEMORY_TOTAL + Long.toString(rt.totalMemory()) + LOG_MEMORY_BYTES);
        log.println("#");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remapTo(File out, PrintWriter log) throws IOException, ClassFileException {
        if (!this.hasMap) {
            this.createMap(log);
        }
        this.classTree.dump(log);
        Enumeration<? extends ZipEntry> entries = this.inJar.entries();
        ZipOutputStream outJar = null;
        try {
            outJar = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(out)));
            outJar.setComment(Version.getJarComment());
            while (entries.hasMoreElements()) {
                ZipEntry inEntry = entries.nextElement();
                if (inEntry.isDirectory()) continue;
                FilterInputStream inStream = null;
                try {
                    long size;
                    inStream = new DataInputStream(new BufferedInputStream(this.inJar.getInputStream(inEntry)));
                    String inName = inEntry.getName();
                    if (inName.length() > CLASS_EXT.length() && inName.substring(inName.length() - CLASS_EXT.length(), inName.length()).equals(CLASS_EXT)) {
                        ClassFile cf = null;
                        try {
                            cf = ClassFile.create((DataInput)((Object)inStream));
                        }
                        catch (ClassFileException classFileException) {
                            // empty catch block
                        }
                        if (cf == null) continue;
                        cf.setIdString(Version.getClassIdString());
                        Cl cl = this.classTree.getCl(cf.getName());
                        if (cl == null) continue;
                        cf.trimAttrs(this.classTree);
                        cf.updateRefCount();
                        cf.remap(this.classTree, log, this.enableMapClassString);
                        ZipEntry outEntry = new ZipEntry(cf.getName() + CLASS_EXT);
                        outJar.putNextEntry(outEntry);
                        ArrayList<MessageDigest> digests = new ArrayList<MessageDigest>();
                        MessageDigest shaDigest = null;
                        MessageDigest md5Digest = null;
                        FilterOutputStream outputStream = outJar;
                        if (this.enableDigestSHA) {
                            try {
                                shaDigest = MessageDigest.getInstance("SHA-1");
                                digests.add(shaDigest);
                                outputStream = new DigestOutputStream(outputStream, shaDigest);
                            }
                            catch (NoSuchAlgorithmException e) {
                                this.enableDigestSHA = false;
                            }
                        }
                        if (this.enableDigestMD5) {
                            try {
                                md5Digest = MessageDigest.getInstance("MD5");
                                digests.add(md5Digest);
                                outputStream = new DigestOutputStream(outputStream, md5Digest);
                            }
                            catch (NoSuchAlgorithmException e) {
                                this.enableDigestMD5 = false;
                            }
                        }
                        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
                        cf.write(dataOutputStream);
                        dataOutputStream.flush();
                        outJar.closeEntry();
                        this.updateManifest(inName, cf.getName() + CLASS_EXT, digests);
                        continue;
                    }
                    if (STREAM_NAME_MANIFEST.equals(inName.toUpperCase()) || inName.length() > SIGNATURE_PREFIX.length() + 1 + SIGNATURE_EXT.length() && inName.indexOf(SIGNATURE_PREFIX) != -1 && inName.substring(inName.length() - SIGNATURE_EXT.length(), inName.length()).equals(SIGNATURE_EXT) || (size = inEntry.getSize()) == -1L) continue;
                    byte[] bytes = new byte[(int)size];
                    ((DataInputStream)inStream).readFully(bytes);
                    String outName = this.classTree.getOutName(inName);
                    ZipEntry outEntry = new ZipEntry(outName);
                    outJar.putNextEntry(outEntry);
                    ArrayList<MessageDigest> digests = new ArrayList<MessageDigest>();
                    MessageDigest shaDigest = null;
                    MessageDigest md5Digest = null;
                    FilterOutputStream outputStream = outJar;
                    if (this.enableDigestSHA) {
                        try {
                            shaDigest = MessageDigest.getInstance("SHA-1");
                            digests.add(shaDigest);
                            outputStream = new DigestOutputStream(outputStream, shaDigest);
                        }
                        catch (NoSuchAlgorithmException e) {
                            this.enableDigestSHA = false;
                        }
                    }
                    if (this.enableDigestMD5) {
                        try {
                            md5Digest = MessageDigest.getInstance("MD5");
                            digests.add(md5Digest);
                            outputStream = new DigestOutputStream(outputStream, md5Digest);
                        }
                        catch (NoSuchAlgorithmException e) {
                            this.enableDigestMD5 = false;
                        }
                    }
                    DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
                    dataOutputStream.write(bytes, 0, bytes.length);
                    dataOutputStream.flush();
                    outJar.closeEntry();
                    this.updateManifest(inName, outName, digests);
                }
                finally {
                    if (inStream == null) continue;
                    inStream.close();
                }
            }
            ZipEntry outEntry = new ZipEntry(STREAM_NAME_MANIFEST);
            outJar.putNextEntry(outEntry);
            PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outJar)));
            this.newManifest.writeString(writer);
            writer.flush();
            outJar.closeEntry();
        }
        finally {
            if (outJar != null) {
                outJar.close();
            }
        }
    }

    public void close() {
        if (this.inJar != null) {
            try {
                this.inJar.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inJar = null;
        }
    }

    private void parseManifest() throws IOException {
        this.oldManifest = new SectionList();
        Enumeration<? extends ZipEntry> entries = this.inJar.entries();
        while (entries.hasMoreElements()) {
            ZipEntry inEntry = entries.nextElement();
            String name = inEntry.getName();
            if (!STREAM_NAME_MANIFEST.equals(name.toUpperCase())) continue;
            this.oldManifest.parse(this.inJar.getInputStream(inEntry));
            break;
        }
        this.newManifest = new SectionList();
        Section version = this.oldManifest.find(MANIFEST_VERSION_TAG, MANIFEST_VERSION_VALUE);
        if (version == null) {
            version = new Section();
            version.add(MANIFEST_VERSION_TAG, MANIFEST_VERSION_VALUE);
        }
        this.newManifest.add(version);
        for (Section section : this.oldManifest) {
            if (section == null || section == version) continue;
            Header name = section.findTag(MANIFEST_NAME_TAG);
            if (name == null) {
                this.newManifest.add(section);
                continue;
            }
            String value = name.getValue();
            if (value.length() <= 0 || value.charAt(value.length() - 1) != '/') continue;
            this.newManifest.add(section);
        }
    }

    private void updateManifest(String inName, String outName, List<MessageDigest> digests) {
        Section oldSection = this.oldManifest.find(MANIFEST_NAME_TAG, inName);
        if (oldSection != null) {
            Section newSection = new Section();
            newSection.add(MANIFEST_NAME_TAG, outName);
            for (Header header : oldSection) {
                if (header.getTag().equals(MANIFEST_NAME_TAG) || header.getTag().indexOf("Digest") != -1) continue;
                newSection.add(header);
            }
            if (digests.size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (MessageDigest digest : digests) {
                    sb.append(digest.getAlgorithm());
                    sb.append(" ");
                }
                if (sb.length() > 0) {
                    newSection.add(MANIFEST_DIGESTALG_TAG, sb.toString());
                }
                for (MessageDigest digest : digests) {
                    newSection.add(digest.getAlgorithm() + "-Digest", Tools.toBase64(digest.digest()));
                }
            }
            this.newManifest.add(newSection);
        }
    }
}

