/*
 * Decompiled with CFR 0.152.
 */
package com.rl.obf;

import com.rl.obf.RGSException;
import com.rl.obf.RgsEntry;
import com.rl.obf.RgsEntryType;
import com.rl.obf.classfile.ClassConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Arrays;

public class RgsEnum {
    public static final String OPTION_PUBLIC = "public";
    public static final String OPTION_PROTECTED = "protected";
    public static final String OPTION_PUB_PROT_ONLY = "pub_prot_only";
    public static final String OPTION_METHOD = "method";
    public static final String OPTION_FIELD = "field";
    public static final String OPTION_AND_CLASS = "and_class";
    public static final String OPTION_EXTENDS = "extends";
    public static final String ACCESS_PUBLIC = "public";
    public static final String ACCESS_PRIVATE = "private";
    public static final String ACCESS_PROTECTED = "protected";
    public static final String ACCESS_STATIC = "static";
    public static final String ACCESS_FINAL = "final";
    public static final String ACCESS_SYNCHRONIZED = "synchronized";
    public static final String ACCESS_BRIDGE = "bridge";
    public static final String ACCESS_VOLATILE = "volatile";
    public static final String ACCESS_VARARGS = "varargs";
    public static final String ACCESS_TRANSIENT = "transient";
    public static final String ACCESS_NATIVE = "native";
    public static final String ACCESS_INTERFACE = "interface";
    public static final String ACCESS_ABSTRACT = "abstract";
    public static final String ACCESS_STRICT = "strict";
    public static final String ACCESS_SYNTHETIC = "synthetic";
    public static final String ACCESS_ANNOTATION = "annotation";
    public static final String ACCESS_ENUM = "enum";
    public static final String[] CLASS_ACCESS = new String[]{"public", "final", "interface", "abstract", "annotation", "enum"};
    public static final String[] METHOD_ACCESS = new String[]{"public", "private", "protected", "static", "final", "synchronized", "bridge", "varargs", "native", "abstract", "strict"};
    public static final String[] FIELD_ACCESS = new String[]{"public", "private", "protected", "static", "final", "volatile", "transient", "enum"};
    private static final String DEFAULT_RGS = ".option Applet\n.option Application\n.option Serializable\n.option RMI\n.option RuntimeAnnotations\n.option MapClassString\n.option Repackage\n.option Generic\n";
    private StreamTokenizer tk;
    private RgsEntry next;
    private RGSException nextException;

    private static int toAccessFlag(String accessString) throws RGSException {
        if ("public".equals(accessString)) {
            return 1;
        }
        if (ACCESS_PRIVATE.equals(accessString)) {
            return 2;
        }
        if ("protected".equals(accessString)) {
            return 4;
        }
        if (ACCESS_STATIC.equals(accessString)) {
            return 8;
        }
        if (ACCESS_FINAL.equals(accessString)) {
            return 16;
        }
        if (ACCESS_SYNCHRONIZED.equals(accessString)) {
            return 32;
        }
        if (ACCESS_BRIDGE.equals(accessString)) {
            return 64;
        }
        if (ACCESS_VOLATILE.equals(accessString)) {
            return 64;
        }
        if (ACCESS_VARARGS.equals(accessString)) {
            return 128;
        }
        if (ACCESS_TRANSIENT.equals(accessString)) {
            return 128;
        }
        if (ACCESS_NATIVE.equals(accessString)) {
            return 256;
        }
        if (ACCESS_INTERFACE.equals(accessString)) {
            return 512;
        }
        if (ACCESS_ABSTRACT.equals(accessString)) {
            return 1024;
        }
        if (ACCESS_STRICT.equals(accessString)) {
            return 2048;
        }
        if (ACCESS_SYNTHETIC.equals(accessString)) {
            return 4096;
        }
        if (ACCESS_ANNOTATION.equals(accessString)) {
            return 8192;
        }
        if (ACCESS_ENUM.equals(accessString)) {
            return 16384;
        }
        throw new RGSException("Invalid access string " + accessString);
    }

    private static int decodeAccessFlags(RgsEntryType entryType, String accessString) throws RGSException {
        int accessMask = 0;
        int accessSetting = 0;
        while (accessString != null && accessString.length() >= 5) {
            int endIndex;
            boolean invert = false;
            if (accessString.charAt(0) != ';') {
                throw new RGSException("Invalid access flags '" + accessString + "'");
            }
            int startIndex = 1;
            if (accessString.charAt(1) == '!') {
                invert = true;
                startIndex = 2;
            }
            String flagString = (endIndex = accessString.indexOf(59, startIndex)) == -1 ? accessString.substring(startIndex) : accessString.substring(startIndex, endIndex);
            accessString = endIndex == -1 ? null : accessString.substring(endIndex);
            if (!((entryType != RgsEntryType.CLASS && entryType != RgsEntryType.NOT_CLASS || Arrays.asList(CLASS_ACCESS).contains(flagString)) && (entryType != RgsEntryType.METHOD && entryType != RgsEntryType.NOT_METHOD || Arrays.asList(METHOD_ACCESS).contains(flagString)) && (entryType != RgsEntryType.FIELD && entryType != RgsEntryType.NOT_FIELD || Arrays.asList(FIELD_ACCESS).contains(flagString)))) {
                throw new RGSException("Invalid access flag '" + flagString + "'");
            }
            int flag = RgsEnum.toAccessFlag(flagString);
            accessMask |= flag;
            if (invert) continue;
            accessSetting |= flag;
        }
        return (accessSetting << 16) + accessMask;
    }

    public RgsEnum(InputStream rgs) {
        this.tk = new StreamTokenizer(new BufferedReader(rgs != null ? new InputStreamReader(rgs) : new StringReader(DEFAULT_RGS)));
        this.tk.resetSyntax();
        this.tk.whitespaceChars(0, 32);
        this.tk.wordChars(94, 94);
        this.tk.wordChars(33, 33);
        this.tk.wordChars(42, 42);
        this.tk.wordChars(46, 46);
        this.tk.wordChars(59, 59);
        this.tk.wordChars(95, 95);
        this.tk.wordChars(91, 91);
        this.tk.wordChars(40, 41);
        this.tk.wordChars(36, 36);
        this.tk.wordChars(47, 57);
        this.tk.wordChars(65, 90);
        this.tk.wordChars(97, 122);
        this.tk.commentChar(35);
        this.tk.eolIsSignificant(true);
        this.readNext();
    }

    public boolean hasNext() throws RGSException {
        if (this.nextException != null) {
            throw this.nextException;
        }
        return this.next != null;
    }

    public RgsEntry next() throws RGSException {
        RgsEntry thisOne = this.next;
        RGSException thisException = this.nextException;
        this.readNext();
        if (thisException != null) {
            throw thisException;
        }
        return thisOne;
    }

    private void readNext() {
        this.nextException = null;
        RgsEntry entry = null;
        try {
            int ttype;
            Enum directive = null;
            int accessMask = 0;
            int accessSetting = 0;
            String name = null;
            String descriptor = null;
            boolean hasExtends = false;
            String extendsName = null;
            while ((ttype = this.tk.nextToken()) != -1) {
                if (ttype == -3) {
                    if (directive == null) {
                        if (this.tk.sval.equals(RgsEntryType.OPTION.toString())) {
                            directive = RgsEntryType.OPTION;
                            continue;
                        }
                        if (this.tk.sval.equals(RgsEntryType.ATTR.toString())) {
                            directive = RgsEntryType.ATTR;
                            continue;
                        }
                        if (this.tk.sval.equals(RgsEntryType.NOWARN.toString())) {
                            directive = RgsEntryType.NOWARN;
                            continue;
                        }
                        if (this.tk.sval.equals(RgsEntryType.PACKAGE_MAP.toString())) {
                            directive = RgsEntryType.PACKAGE_MAP;
                            continue;
                        }
                        if (this.tk.sval.equals(RgsEntryType.REPACKAGE_MAP.toString())) {
                            directive = RgsEntryType.REPACKAGE_MAP;
                            continue;
                        }
                        if (this.tk.sval.equals(RgsEntryType.CLASS_MAP.toString())) {
                            directive = RgsEntryType.CLASS_MAP;
                            continue;
                        }
                        if (this.tk.sval.equals(RgsEntryType.METHOD_MAP.toString())) {
                            directive = RgsEntryType.METHOD_MAP;
                            continue;
                        }
                        if (this.tk.sval.equals(RgsEntryType.FIELD_MAP.toString())) {
                            directive = RgsEntryType.FIELD_MAP;
                            continue;
                        }
                        if (this.tk.sval.startsWith(RgsEntryType.CLASS.toString())) {
                            directive = RgsEntryType.CLASS;
                            accessMask = RgsEnum.decodeAccessFlags((RgsEntryType)directive, this.tk.sval.substring(RgsEntryType.CLASS.length()));
                            accessSetting = accessMask >> 16;
                            accessMask &= 0xFFFF;
                            continue;
                        }
                        if (this.tk.sval.startsWith(RgsEntryType.NOT_CLASS.toString())) {
                            directive = RgsEntryType.NOT_CLASS;
                            accessMask = RgsEnum.decodeAccessFlags((RgsEntryType)directive, this.tk.sval.substring(RgsEntryType.NOT_CLASS.length()));
                            accessSetting = accessMask >> 16;
                            accessMask &= 0xFFFF;
                            continue;
                        }
                        if (this.tk.sval.startsWith(RgsEntryType.METHOD.toString())) {
                            directive = RgsEntryType.METHOD;
                            accessMask = RgsEnum.decodeAccessFlags((RgsEntryType)directive, this.tk.sval.substring(RgsEntryType.METHOD.length()));
                            accessSetting = accessMask >> 16;
                            accessMask &= 0xFFFF;
                            continue;
                        }
                        if (this.tk.sval.startsWith(RgsEntryType.NOT_METHOD.toString())) {
                            directive = RgsEntryType.NOT_METHOD;
                            accessMask = RgsEnum.decodeAccessFlags((RgsEntryType)directive, this.tk.sval.substring(RgsEntryType.NOT_METHOD.length()));
                            accessSetting = accessMask >> 16;
                            accessMask &= 0xFFFF;
                            continue;
                        }
                        if (this.tk.sval.startsWith(RgsEntryType.FIELD.toString())) {
                            directive = RgsEntryType.FIELD;
                            accessMask = RgsEnum.decodeAccessFlags((RgsEntryType)directive, this.tk.sval.substring(RgsEntryType.FIELD.length()));
                            accessSetting = accessMask >> 16;
                            accessMask &= 0xFFFF;
                            continue;
                        }
                        if (this.tk.sval.startsWith(RgsEntryType.NOT_FIELD.toString())) {
                            directive = RgsEntryType.NOT_FIELD;
                            accessMask = RgsEnum.decodeAccessFlags((RgsEntryType)directive, this.tk.sval.substring(RgsEntryType.NOT_FIELD.length()));
                            accessSetting = accessMask >> 16;
                            accessMask &= 0xFFFF;
                            continue;
                        }
                        throw new RGSException("Unknown keyword '" + this.tk.sval + "'");
                    }
                    if (entry == null) {
                        switch (1.$SwitchMap$com$rl$obf$RgsEntryType[directive.ordinal()]) {
                            case 1: {
                                if (!Arrays.asList(ClassConstants.KNOWN_OPTIONS).contains(this.tk.sval)) {
                                    throw new RGSException("Unknown .option '" + this.tk.sval + "'");
                                }
                                entry = new RgsEntry((RgsEntryType)directive, this.tk.sval);
                                break;
                            }
                            case 2: {
                                if (!Arrays.asList(ClassConstants.KNOWN_ATTRS).contains(this.tk.sval)) {
                                    throw new RGSException("Unknown .attribute '" + this.tk.sval + "'");
                                }
                                entry = new RgsEntry((RgsEntryType)directive, this.tk.sval);
                                break;
                            }
                            case 3: {
                                entry = new RgsEntry((RgsEntryType)directive, this.tk.sval);
                                break;
                            }
                            case 4: 
                            case 5: {
                                entry = new RgsEntry((RgsEntryType)directive, this.tk.sval);
                                entry.accessMask = accessMask;
                                entry.accessSetting = accessSetting;
                                break;
                            }
                            case 6: 
                            case 7: {
                                if (name == null) {
                                    name = this.tk.sval;
                                    break;
                                }
                                if (descriptor != null) break;
                                descriptor = this.tk.sval;
                                entry = new RgsEntry((RgsEntryType)directive, name, descriptor);
                                entry.accessMask = accessMask;
                                entry.accessSetting = accessSetting;
                                break;
                            }
                            case 8: 
                            case 9: {
                                if (name == null) {
                                    name = this.tk.sval;
                                    break;
                                }
                                descriptor = this.tk.sval;
                                entry = new RgsEntry((RgsEntryType)directive, name, descriptor);
                                entry.accessMask = accessMask;
                                entry.accessSetting = accessSetting;
                                break;
                            }
                            case 10: 
                            case 11: {
                                if (name == null) {
                                    name = this.tk.sval;
                                    RgsEnum.checkClassSpec(name);
                                    break;
                                }
                                String obfName = this.tk.sval;
                                RgsEnum.checkJavaIdentifier(obfName);
                                entry = new RgsEntry((RgsEntryType)directive, name);
                                entry.obfName = obfName;
                                break;
                            }
                            case 12: {
                                if (name == null) {
                                    name = this.tk.sval;
                                    RgsEnum.checkClassSpec(name);
                                    break;
                                }
                                String obfName = this.tk.sval;
                                RgsEnum.checkJavaInnerIdentifier(obfName);
                                entry = new RgsEntry((RgsEntryType)directive, name);
                                entry.obfName = obfName;
                                break;
                            }
                            case 13: {
                                if (name == null) {
                                    name = this.tk.sval;
                                    RgsEnum.checkMethodOrFieldSpec(name);
                                    break;
                                }
                                if (descriptor == null) {
                                    descriptor = this.tk.sval;
                                    RgsEnum.checkMethodDescriptor(descriptor);
                                    break;
                                }
                                String obfName = this.tk.sval;
                                RgsEnum.checkJavaIdentifier(obfName);
                                entry = new RgsEntry((RgsEntryType)directive, name, descriptor);
                                entry.obfName = obfName;
                                break;
                            }
                            case 14: {
                                if (name == null) {
                                    name = this.tk.sval;
                                    RgsEnum.checkMethodOrFieldSpec(name);
                                    break;
                                }
                                String obfName = this.tk.sval;
                                RgsEnum.checkJavaIdentifier(obfName);
                                entry = new RgsEntry((RgsEntryType)directive, name);
                                entry.obfName = obfName;
                            }
                        }
                        continue;
                    }
                    if (directive == RgsEntryType.CLASS || directive == RgsEntryType.NOT_CLASS) {
                        if (this.tk.sval.equals("public")) {
                            if (entry.retainToPublic || entry.retainToProtected || entry.retainPubProtOnly) {
                                throw new RGSException("Multiple access levels");
                            }
                            entry.retainToPublic = true;
                            continue;
                        }
                        if (this.tk.sval.equals(OPTION_PUB_PROT_ONLY)) {
                            if (entry.retainToPublic || entry.retainToProtected || entry.retainPubProtOnly) {
                                throw new RGSException("Multiple access levels");
                            }
                            entry.retainPubProtOnly = true;
                            continue;
                        }
                        if (this.tk.sval.equals("protected")) {
                            if (entry.retainToPublic || entry.retainToProtected || entry.retainPubProtOnly) {
                                throw new RGSException("Multiple access levels");
                            }
                            entry.retainToProtected = true;
                            continue;
                        }
                        if (this.tk.sval.equals(OPTION_FIELD)) {
                            if (!(entry.retainToPublic || entry.retainPubProtOnly || entry.retainToProtected)) {
                                throw new RGSException("No access level");
                            }
                            if (entry.retainMethodsOnly || entry.retainFieldsOnly) {
                                throw new RGSException("Multiple field or method");
                            }
                            entry.retainFieldsOnly = true;
                            continue;
                        }
                        if (this.tk.sval.equals(OPTION_METHOD)) {
                            if (!(entry.retainToPublic || entry.retainPubProtOnly || entry.retainToProtected)) {
                                throw new RGSException("No access level");
                            }
                            if (entry.retainMethodsOnly || entry.retainFieldsOnly) {
                                throw new RGSException("Multiple field or method");
                            }
                            entry.retainMethodsOnly = true;
                            continue;
                        }
                        if (this.tk.sval.equals(OPTION_EXTENDS)) {
                            hasExtends = true;
                            continue;
                        }
                        if (hasExtends) {
                            extendsName = this.tk.sval;
                            RgsEnum.checkClassSpec(extendsName);
                            entry.extendsName = extendsName;
                            continue;
                        }
                        throw new RGSException("Unknown keyword '" + this.tk.sval + "'");
                    }
                    if (directive == RgsEntryType.METHOD || directive == RgsEntryType.NOT_METHOD || directive == RgsEntryType.FIELD || directive == RgsEntryType.NOT_FIELD) {
                        if (this.tk.sval.equals(OPTION_AND_CLASS)) {
                            entry.retainAndClass = true;
                            continue;
                        }
                        if (this.tk.sval.equals(OPTION_EXTENDS)) {
                            hasExtends = true;
                            continue;
                        }
                        if (hasExtends) {
                            extendsName = this.tk.sval;
                            RgsEnum.checkClassSpec(extendsName);
                            entry.extendsName = extendsName;
                            continue;
                        }
                        throw new RGSException("Unknown keyword '" + this.tk.sval + "'");
                    }
                    throw new RGSException("Unknown keyword '" + this.tk.sval + "'");
                }
                if (ttype == 10) {
                    if (entry == null) continue;
                    break;
                }
                throw new RGSException("Invalid character '" + (char)ttype + "'");
            }
            this.next = entry;
        }
        catch (RGSException e) {
            try {
                int ttype;
                while ((ttype = this.tk.nextToken()) != -1 && ttype != 10) {
                }
            }
            catch (IOException accessMask) {
                // empty catch block
            }
            String excMsg = e.getMessage();
            this.nextException = new RGSException("Parser error at line " + Integer.toString(this.tk.lineno()) + " of script file" + (excMsg != null ? ": " + excMsg : ""));
        }
        catch (IOException e) {
            try {
                int ttype;
                while ((ttype = this.tk.nextToken()) != -1 && ttype != 10) {
                }
            }
            catch (IOException excMsg) {
                // empty catch block
            }
            String excMsg = e.getMessage();
            this.nextException = new RGSException("Parser error at line " + Integer.toString(this.tk.lineno()) + " of script file" + (excMsg != null ? ": " + excMsg : ""));
        }
    }

    private static void checkMethodDescriptor(String s) throws RGSException {
        if (s.length() == 0 || s.charAt(0) != '(') {
            throw new RGSException("Invalid method descriptor '" + s + "'");
        }
        s = s.substring(1);
        while (s.length() > 0 && s.charAt(0) != ')') {
            s = RgsEnum.checkFirstJavaType(s);
        }
        RgsEnum.checkJavaType(s.substring(1));
    }

    private static String checkFirstJavaType(String s) throws RGSException {
        while (s.charAt(0) == '[') {
            if ((s = s.substring(1)).length() != 0) continue;
            throw new RGSException("Invalid type '" + s + "'");
        }
        int pos = 0;
        switch (s.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                break;
            }
            case 'L': {
                pos = s.indexOf(59);
                if (pos == -1) {
                    throw new RGSException("Invalid type '" + s + "'");
                }
                RgsEnum.checkClassSpec(s.substring(0, pos));
                break;
            }
            default: {
                throw new RGSException("Invalid type '" + s + "'");
            }
        }
        return s.substring(pos + 1);
    }

    private static void checkJavaType(String s) throws RGSException {
        if (!RgsEnum.checkFirstJavaType(s).equals("")) {
            throw new RGSException("Invalid type '" + s + "'");
        }
    }

    private static void checkMethodOrFieldSpec(String s) throws RGSException {
        if (s.length() == 0) {
            throw new RGSException("Invalid method/field specifier '" + s + "'");
        }
        int pos = s.lastIndexOf(47);
        if (pos == -1) {
            throw new RGSException("Invalid method/field specifier '" + s + "'");
        }
        RgsEnum.checkJavaIdentifier(s.substring(pos + 1));
        RgsEnum.checkClassSpec(s.substring(0, pos));
    }

    private static void checkClassSpec(String s) throws RGSException {
        if (s.length() == 0) {
            throw new RGSException("Invalid class specifier '" + s + "'");
        }
        int pos = -1;
        while ((pos = s.lastIndexOf(36)) != -1) {
            RgsEnum.checkJavaInnerIdentifier(s.substring(pos + 1));
            s = s.substring(0, pos);
        }
        while ((pos = s.lastIndexOf(47)) != -1) {
            RgsEnum.checkJavaIdentifier(s.substring(pos + 1));
            s = s.substring(0, pos);
        }
        RgsEnum.checkJavaIdentifier(s);
    }

    private static void checkClassWCSpec(String s) throws RGSException {
        if (s.length() == 0) {
            throw new RGSException("Invalid class specifier '" + s + "'");
        }
        if (s.charAt(s.length() - 1) == '*') {
            if (s.length() > 1 && s.charAt(s.length() - 2) == '*') {
                if (!s.equals("**")) {
                    if (s.length() < 4 || s.charAt(s.length() - 3) != '/') {
                        throw new RGSException("Invalid class specifier '" + s + "'");
                    }
                    s = s.substring(0, s.length() - 3);
                }
            } else if (!s.equals("*")) {
                if (s.length() < 3 || s.charAt(s.length() - 2) != '/') {
                    throw new RGSException("Invalid class specifier '" + s + "'");
                }
                s = s.substring(0, s.length() - 2);
            }
            int pos = -1;
            while ((pos = s.lastIndexOf(47)) != -1) {
                RgsEnum.checkJavaIdentifier(s.substring(pos + 1));
                s = s.substring(0, pos);
            }
            RgsEnum.checkJavaIdentifier(s);
        } else {
            RgsEnum.checkClassSpec(s);
        }
    }

    private static void checkJavaIdentifier(String s) throws RGSException {
        if (s.length() == 0 || !Character.isJavaIdentifierStart(s.charAt(0))) {
            throw new RGSException("Invalid identifier '" + s + "'");
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            throw new RGSException("Invalid identifier '" + s + "'");
        }
    }

    private static void checkJavaInnerIdentifier(String s) throws RGSException {
        if (s.length() == 0) {
            throw new RGSException("Invalid inner identifier '" + s + "'");
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            throw new RGSException("Invalid inner identifier '" + s + "'");
        }
    }
}

