/*
 * Decompiled with CFR 0.152.
 */
package com.rl.obf.classfile;

import com.rl.obf.classfile.AttrInfo;
import com.rl.obf.classfile.ClassFile;
import com.rl.obf.classfile.ClassFileException;
import com.rl.obf.classfile.ConstantPool;
import com.rl.obf.classfile.NameMapper;
import com.rl.obf.classfile.ParameterAnnotationsInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class ParameterAnnotationsAttrInfo
extends AttrInfo {
    private List<ParameterAnnotationsInfo> parameterAnnotationsTable;

    protected ParameterAnnotationsAttrInfo(ClassFile cf, int attrNameIndex, int attrLength) {
        super(cf, attrNameIndex, attrLength);
    }

    @Override
    protected void markUtf8RefsInInfo(ConstantPool pool) throws ClassFileException {
        for (ParameterAnnotationsInfo pa : this.parameterAnnotationsTable) {
            pa.markUtf8Refs(pool);
        }
    }

    @Override
    protected void readInfo(DataInput din) throws IOException, ClassFileException {
        int u1numParameters = din.readUnsignedByte();
        this.parameterAnnotationsTable = new ArrayList<ParameterAnnotationsInfo>(u1numParameters);
        for (int i = 0; i < u1numParameters; ++i) {
            this.parameterAnnotationsTable.add(ParameterAnnotationsInfo.create(din));
        }
    }

    @Override
    public void writeInfo(DataOutput dout) throws IOException, ClassFileException {
        dout.writeByte(this.parameterAnnotationsTable.size());
        for (ParameterAnnotationsInfo pa : this.parameterAnnotationsTable) {
            pa.write(dout);
        }
    }

    @Override
    protected void remap(ClassFile cf, NameMapper nm) throws ClassFileException {
        for (ParameterAnnotationsInfo pa : this.parameterAnnotationsTable) {
            pa.remap(cf, nm);
        }
    }
}

