/*
 * Decompiled with CFR 0.152.
 */
package com.rl.util.rfc822;

import com.rl.util.rfc822.Header;
import com.rl.util.rfc822.Section;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SectionList
implements Iterable<Section> {
    private List<Section> sections = new ArrayList<Section>();

    public void parse(InputStream in) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        Section section = null;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (section != null && line.indexOf(58) == -1) {
                    this.add(section);
                    section = null;
                }
                if (section == null && line.indexOf(58) == -1) continue;
                if (section == null) {
                    section = new Section();
                }
                boolean done = false;
                while (!done) {
                    reader.mark(80);
                    String nextLine = reader.readLine();
                    if (nextLine == null) {
                        done = true;
                        continue;
                    }
                    if (nextLine.indexOf(32) == 0) {
                        line = line.concat(nextLine.substring(1));
                        continue;
                    }
                    reader.reset();
                    done = true;
                }
                section.add(Header.parse(line));
            }
        }
        catch (IOException e) {
            return;
        }
    }

    public void add(Section section) {
        this.sections.add(section);
    }

    @Override
    public Iterator<Section> iterator() {
        return this.sections.iterator();
    }

    public Section find(String tag, String value) {
        return this.find(new Header(tag, value));
    }

    public Section find(Header header) {
        for (Section section : this.sections) {
            if (!section.hasHeader(header)) continue;
            return section;
        }
        return null;
    }

    public void writeString(Writer writer) throws IOException {
        for (Section section : this.sections) {
            section.writeString(writer);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Section section : this.sections) {
            sb.append(section.toString());
        }
        return sb.toString();
    }
}

