/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.mmv;

public class CsvData
implements Comparable<CsvData> {
    private final String srgName;
    private String mcpName;
    private final int side;
    private String comment;
    private boolean needsQuoted;

    public CsvData(String srgName, String mcpName, int side, String comment) {
        this.srgName = srgName;
        this.mcpName = mcpName;
        this.side = side;
        if (comment.contains(",") || !comment.isEmpty() && comment.charAt(0) == '\"' && comment.charAt(comment.length() - 1) == '\"') {
            this.needsQuoted = true;
            this.comment = comment.charAt(0) == '\"' && comment.charAt(comment.length() - 1) == '\"' ? comment.substring(1, comment.length() - 1) : comment;
        } else {
            this.comment = comment;
            this.needsQuoted = false;
        }
    }

    public String toCsv() {
        return this.srgName + "," + this.mcpName + "," + this.side + "," + (this.needsQuoted ? "\"" + this.comment + "\"" : this.comment);
    }

    public String getSrgName() {
        return this.srgName;
    }

    public String getMcpName() {
        return this.mcpName;
    }

    public CsvData setMcpName(String mcpName) {
        this.mcpName = mcpName;
        return this;
    }

    public int getSide() {
        return this.side;
    }

    public String getComment() {
        return this.comment;
    }

    public CsvData setComment(String comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public int compareTo(CsvData o) {
        if (o != null) {
            return this.srgName.compareTo(o.srgName);
        }
        return 1;
    }

    public boolean contains(String s) {
        return this.mcpName.contains(s) || this.comment.contains(s);
    }
}

