/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.mmv;

import bspkrs.mmv.SplittedNaturalComparator;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class VersionFetcher {
    private final String jsonUrl = "http://export.mcpbot.bspk.rs/versions.json";
    private List<String> versions;

    public List<String> getVersions(boolean force) throws IOException {
        if (this.versions == null || force) {
            URL url = new URL("http://export.mcpbot.bspk.rs/versions.json");
            URLConnection connection = url.openConnection();
            connection.addRequestProperty("User-Agent", "MMV/1.0.0");
            BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            Map json = new Gson().fromJson((Reader)br, Map.class);
            this.versions = new ArrayList<String>();
            for (String mcVer : json.keySet()) {
                for (String channel : ((Map)json.get(mcVer)).keySet()) {
                    for (Double ver : (ArrayList)((Map)json.get(mcVer)).get(channel)) {
                        this.versions.add(mcVer + "_" + channel + "_" + String.format("%.0f", ver));
                    }
                }
            }
            Collections.sort(this.versions, Collections.reverseOrder(new SplittedNaturalComparator("_")));
            return this.versions;
        }
        return this.versions;
    }
}

