/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.vars;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.LVTVariable;
import org.jetbrains.java.decompiler.modules.decompiler.vars.StartEndPair;

public class LocalVariableTable {
    private Map<StartEndPair, Set<LVTVariable>> endpoints;
    private ArrayList<LVTVariable> allLVT;
    private Map<Integer, List<LVTVariable>> mapLVT;

    public LocalVariableTable(int len) {
        this.endpoints = new HashMap<StartEndPair, Set<LVTVariable>>(len);
        this.allLVT = new ArrayList(len);
    }

    public void addVariable(LVTVariable v) {
        this.allLVT.add(v);
        v.addTo(this.endpoints);
    }

    public void mergeLVTs(LocalVariableTable otherLVT) {
        for (LVTVariable other : otherLVT.allLVT) {
            int idx = this.allLVT.indexOf(other);
            if (idx < 0) {
                this.allLVT.add(other);
                continue;
            }
            LVTVariable mine = this.allLVT.get(idx);
            mine.merge(other);
        }
        this.mapLVT = null;
    }

    public LVTVariable find(int index, Integer bytecodeOffset) {
        Map<Integer, List<LVTVariable>> map = this.getMapVarNames();
        if (!map.containsKey(index)) {
            return null;
        }
        for (LVTVariable lvt : map.get(index)) {
            if (lvt.start != bytecodeOffset) continue;
            return lvt;
        }
        return null;
    }

    public Map<Integer, List<LVTVariable>> getMapVarNames() {
        if (this.mapLVT == null) {
            this.buildNameMap();
        }
        return this.mapLVT;
    }

    private void buildNameMap() {
        HashMap<Integer, Integer> versions = new HashMap<Integer, Integer>();
        this.mapLVT = new HashMap<Integer, List<LVTVariable>>();
        for (LVTVariable lvt : this.allLVT) {
            Integer idx = (Integer)versions.get(lvt.index);
            if (idx == null) {
                idx = 1;
            } else {
                Integer n = idx;
                Integer n2 = idx = Integer.valueOf(idx + 1);
            }
            versions.put(lvt.index, idx);
            List<LVTVariable> lvtList = this.mapLVT.get(lvt.index);
            if (lvtList == null) {
                lvtList = new ArrayList<LVTVariable>();
                this.mapLVT.put(lvt.index, lvtList);
            }
            lvtList.add(lvt);
        }
    }

    public List<LVTVariable> getCandidates(int index) {
        return this.getMapVarNames().get(index);
    }

    public Map<Integer, LVTVariable> getVars(Statement statement) {
        HashMap<Integer, LVTVariable> ret = new HashMap<Integer, LVTVariable>();
        if (statement == null) {
            return ret;
        }
        StartEndPair sepair = statement.getStartEndRange();
        if (this.endpoints.containsKey(sepair)) {
            for (LVTVariable lvt : this.endpoints.get(sepair)) {
                ret.put(lvt.index, lvt);
            }
        }
        return ret;
    }
}

