/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.attr;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.modules.decompiler.vars.LVTVariable;
import org.jetbrains.java.decompiler.modules.decompiler.vars.LocalVariableTable;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class StructLocalVariableTableAttribute
extends StructGeneralAttribute {
    private Map<Integer, List<LVTVariable>> EMPTY_LVT = Collections.emptyMap();
    private LocalVariableTable lvt;

    @Override
    public void initContent(ConstantPool pool) throws IOException {
        DataInputFullStream data = this.stream();
        int len = data.readUnsignedShort();
        boolean isLVTT = this.getName().equals("LocalVariableTypeTable");
        if (len > 0) {
            this.lvt = new LocalVariableTable(len);
            for (int i = 0; i < len; ++i) {
                int start = data.readUnsignedShort();
                int vlen = data.readUnsignedShort();
                int nameIndex = data.readUnsignedShort();
                int descIndex = data.readUnsignedShort();
                int varIndex = data.readUnsignedShort();
                LVTVariable v = new LVTVariable(pool.getPrimitiveConstant(nameIndex).getString(), pool.getPrimitiveConstant(descIndex).getString(), start, start + vlen, varIndex, isLVTT);
                this.lvt.addVariable(v);
            }
        }
    }

    public void addLocalVariableTable(StructLocalVariableTableAttribute attr) {
        if (this.lvt == null) {
            this.lvt = attr.lvt;
        } else {
            this.lvt.mergeLVTs(attr.lvt);
            attr.lvt = this.lvt;
        }
    }

    public Map<Integer, List<LVTVariable>> getMapVarNames() {
        return this.lvt == null ? this.EMPTY_LVT : this.lvt.getMapVarNames();
    }

    public LocalVariableTable getLVT() {
        return this.lvt;
    }
}

