/*
 * Decompiled with CFR 0.152.
 */
package com.rl.obf;

import com.rl.obf.GuardDB;
import com.rl.obf.RgsEnum;
import com.rl.obf.Version;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.zip.ZipException;

public class RetroGuardImpl {
    public static final String DEFAULT_IN_FILE_NAME = "in.jar";
    public static final String DEFAULT_OUT_FILE_NAME = "out.jar";
    public static final String DEFAULT_RGS_FILE_NAME = "script.rgs";
    public static final String DEFAULT_LOG_FILE_NAME = "retroguard.log";
    private static final String LOG_TITLE_PRE_VERSION = "# RetroGuard MCP v";
    private static final String LOG_TITLE_POST_VERSION = "";
    private static final String LOG_CREATED = "# Logfile created on ";
    private static final String LOG_INPUT_FILE = "# Jar file to be obfuscated:           ";
    private static final String LOG_OUTPUT_FILE = "# Target Jar file for obfuscated code: ";
    private static final String LOG_SCRIPT_FILE = "# RetroGuard Script file used:         ";
    private static final String LOG_NO_SCRIPT = "(none, defaults used)";
    private static final String LOG_ERROR = "# Unrecoverable error during obfuscation:";
    private static final String LOG_ZIP_ERROR = "# Review input jar for duplicate classes (same classfile with two different filenames).";
    private static final String SEE_LOG_FILE = "Unrecoverable error during obfuscation, see log file for details.";
    private File inFile;
    private File outFile;
    private File rgsFile;
    private File logFile;

    public static void obfuscate(String inFilename, String outFilename, String rgsFilename, String logFilename) throws Exception {
        File inFile = new File(inFilename == null ? DEFAULT_IN_FILE_NAME : inFilename);
        File outFile = new File(outFilename == null ? DEFAULT_OUT_FILE_NAME : outFilename);
        File rgsFile = new File(rgsFilename == null ? DEFAULT_RGS_FILE_NAME : rgsFilename);
        File logFile = new File(logFilename == null ? DEFAULT_LOG_FILE_NAME : logFilename);
        if (!inFile.exists()) {
            throw new IllegalArgumentException("JAR specified for obfuscation does not exist.");
        }
        if (!inFile.canRead()) {
            throw new IllegalArgumentException("JAR specified for obfuscation exists but cannot be read.");
        }
        if (outFile.exists() && !outFile.canWrite()) {
            throw new IllegalArgumentException("Output JAR file cannot be written to.");
        }
        if (rgsFile.exists() && !rgsFile.canRead()) {
            throw new IllegalArgumentException("Script file exists but cannot be read.");
        }
        if (logFile.exists() && !logFile.canWrite()) {
            throw new IllegalArgumentException("Logfile cannot be written to.");
        }
        RetroGuardImpl.obfuscate(inFile, outFile, rgsFile, logFile);
    }

    public static void obfuscate(File inFile, File outFile, File rgsFile, File logFile) throws Exception {
        new RetroGuardImpl(inFile, outFile, rgsFile, logFile).run();
    }

    private RetroGuardImpl(File inFile, File outFile, File rgsFile, File logFile) {
        this.inFile = inFile;
        this.outFile = outFile;
        this.rgsFile = rgsFile;
        this.logFile = logFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() throws Exception {
        PrintWriter log = null;
        try {
            log = new PrintWriter(new BufferedOutputStream(new FileOutputStream(this.logFile)));
            this.writeLogHeader(log);
            GuardDB db = new GuardDB(this.inFile);
            try {
                FileInputStream rgsInputStream = this.rgsFile.exists() ? new FileInputStream(this.rgsFile) : null;
                db.retain(new RgsEnum(rgsInputStream), log);
                db.logWarnings(log);
                if (rgsInputStream != null) {
                    ((InputStream)rgsInputStream).close();
                }
                db.remapTo(this.outFile, log);
            }
            finally {
                db.close();
            }
        }
        catch (Exception e) {
            if (log != null) {
                log.println();
                log.println(LOG_ERROR);
                if (e instanceof ZipException) {
                    log.println(LOG_ZIP_ERROR);
                }
                log.println("# " + e.toString().replace("\n", "\n# \t"));
                for (StackTraceElement st : e.getStackTrace()) {
                    log.println("# \tat " + st);
                }
                log.println();
                System.err.println(SEE_LOG_FILE);
            }
            throw e;
        }
        finally {
            if (log != null) {
                log.flush();
                log.close();
            }
        }
    }

    private void writeLogHeader(PrintWriter log) {
        log.println("# If this log is to be used for incremental obfuscation / patch generation, ");
        log.println("# add any '.class', '.method', '.field' and '.attribute' restrictions here:");
        log.println();
        log.println();
        log.println("#-DO-NOT-EDIT-BELOW-THIS-LINE------------------DO-NOT-EDIT-BELOW-THIS-LINE--");
        log.println("#");
        log.println(LOG_TITLE_PRE_VERSION + Version.getVersion() + LOG_TITLE_POST_VERSION);
        log.println("#");
        log.println(LOG_CREATED + new Date().toString());
        log.println("#");
        log.println(LOG_INPUT_FILE + this.inFile.getName());
        log.println(LOG_OUTPUT_FILE + this.outFile.getName());
        log.println(LOG_SCRIPT_FILE + (this.rgsFile.exists() ? this.rgsFile.getName() : LOG_NO_SCRIPT));
        log.println("#");
    }
}

