/*
 * Decompiled with CFR 0.152.
 */
package com.rl.obf.classfile;

import com.rl.obf.classfile.ClassFile;
import com.rl.obf.classfile.ClassFileException;
import com.rl.obf.classfile.ConstantPool;
import com.rl.obf.classfile.MemberValuePairInfo;
import com.rl.obf.classfile.NameMapper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AnnotationInfo {
    private int u2typeIndex;
    private List<MemberValuePairInfo> memberValuePairTable;

    public static AnnotationInfo create(DataInput din) throws IOException, ClassFileException {
        AnnotationInfo ai = new AnnotationInfo();
        ai.read(din);
        return ai;
    }

    private AnnotationInfo() {
    }

    protected int getTypeIndex() {
        return this.u2typeIndex;
    }

    protected void markUtf8Refs(ConstantPool pool) throws ClassFileException {
        pool.incRefCount(this.u2typeIndex);
        for (MemberValuePairInfo mvp : this.memberValuePairTable) {
            mvp.markUtf8Refs(pool);
        }
    }

    private void read(DataInput din) throws IOException, ClassFileException {
        this.u2typeIndex = din.readUnsignedShort();
        int u2numMemberValuePairs = din.readUnsignedShort();
        this.memberValuePairTable = new ArrayList<MemberValuePairInfo>(u2numMemberValuePairs);
        for (int i = 0; i < u2numMemberValuePairs; ++i) {
            this.memberValuePairTable.add(MemberValuePairInfo.create(din));
        }
    }

    public void write(DataOutput dout) throws IOException, ClassFileException {
        dout.writeShort(this.u2typeIndex);
        dout.writeShort(this.memberValuePairTable.size());
        for (MemberValuePairInfo mvp : this.memberValuePairTable) {
            mvp.write(dout);
        }
    }

    protected void remap(ClassFile cf, NameMapper nm) throws ClassFileException {
        String oldType = cf.getUtf8(this.u2typeIndex);
        String newType = nm.mapDescriptor(oldType);
        this.u2typeIndex = cf.remapUtf8To(newType, this.u2typeIndex);
        for (MemberValuePairInfo mvp : this.memberValuePairTable) {
            mvp.remap(cf, nm);
        }
    }
}

