/*
 * Decompiled with CFR 0.152.
 */
package com.rl.obf.classfile;

import com.rl.obf.classfile.AnnotationDefaultAttrInfo;
import com.rl.obf.classfile.BootstrapMethodsAttrInfo;
import com.rl.obf.classfile.ClassConstants;
import com.rl.obf.classfile.ClassFile;
import com.rl.obf.classfile.ClassFileException;
import com.rl.obf.classfile.CodeAttrInfo;
import com.rl.obf.classfile.ConstantPool;
import com.rl.obf.classfile.ConstantValueAttrInfo;
import com.rl.obf.classfile.DeprecatedAttrInfo;
import com.rl.obf.classfile.EnclosingMethodAttrInfo;
import com.rl.obf.classfile.ExceptionsAttrInfo;
import com.rl.obf.classfile.InnerClassesAttrInfo;
import com.rl.obf.classfile.LineNumberTableAttrInfo;
import com.rl.obf.classfile.LocalVariableTableAttrInfo;
import com.rl.obf.classfile.LocalVariableTypeTableAttrInfo;
import com.rl.obf.classfile.NameMapper;
import com.rl.obf.classfile.RuntimeInvisibleAnnotationsAttrInfo;
import com.rl.obf.classfile.RuntimeInvisibleParameterAnnotationsAttrInfo;
import com.rl.obf.classfile.RuntimeVisibleAnnotationsAttrInfo;
import com.rl.obf.classfile.RuntimeVisibleParameterAnnotationsAttrInfo;
import com.rl.obf.classfile.SignatureAttrInfo;
import com.rl.obf.classfile.SourceFileAttrInfo;
import com.rl.obf.classfile.StackMapTableAttrInfo;
import com.rl.obf.classfile.SyntheticAttrInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;

public class AttrInfo
implements ClassConstants {
    public static final int CONSTANT_FIELD_SIZE = 6;
    private int u2attrNameIndex;
    private int u4attrLength;
    private byte[] info;
    protected ClassConstants.AttrSource source;
    protected ClassFile cf;

    public static AttrInfo create(DataInput din, ClassFile cf, ClassConstants.AttrSource source) throws IOException, ClassFileException {
        if (din == null) {
            throw new IOException("No input stream was provided.");
        }
        AttrInfo ai = null;
        int attrNameIndex = din.readUnsignedShort();
        int attrLength = din.readInt();
        String attrName = cf.getUtf8(attrNameIndex);
        ai = attrName.equals("Code") ? new CodeAttrInfo(cf, attrNameIndex, attrLength) : (attrName.equals("ConstantValue") ? new ConstantValueAttrInfo(cf, attrNameIndex, attrLength) : (attrName.equals("Exceptions") ? new ExceptionsAttrInfo(cf, attrNameIndex, attrLength) : (attrName.equals("LineNumberTable") ? new LineNumberTableAttrInfo(cf, attrNameIndex, attrLength) : (attrName.equals("SourceFile") ? new SourceFileAttrInfo(cf, attrNameIndex, attrLength) : (attrName.equals("LocalVariableTable") ? new LocalVariableTableAttrInfo(cf, attrNameIndex, attrLength) : (attrName.equals("InnerClasses") ? new InnerClassesAttrInfo(cf, attrNameIndex, attrLength) : (attrName.equals("Synthetic") ? new SyntheticAttrInfo(cf, attrNameIndex, attrLength) : (attrName.equals("Deprecated") ? new DeprecatedAttrInfo(cf, attrNameIndex, attrLength) : (attrName.equals("Signature") ? new SignatureAttrInfo(cf, attrNameIndex, attrLength) : (attrName.equals("LocalVariableTypeTable") ? new LocalVariableTypeTableAttrInfo(cf, attrNameIndex, attrLength) : (attrName.equals("RuntimeVisibleAnnotations") ? new RuntimeVisibleAnnotationsAttrInfo(cf, attrNameIndex, attrLength) : (attrName.equals("RuntimeInvisibleAnnotations") ? new RuntimeInvisibleAnnotationsAttrInfo(cf, attrNameIndex, attrLength) : (attrName.equals("RuntimeVisibleParameterAnnotations") ? new RuntimeVisibleParameterAnnotationsAttrInfo(cf, attrNameIndex, attrLength) : (attrName.equals("RuntimeInvisibleParameterAnnotations") ? new RuntimeInvisibleParameterAnnotationsAttrInfo(cf, attrNameIndex, attrLength) : (attrName.equals("AnnotationDefault") ? new AnnotationDefaultAttrInfo(cf, attrNameIndex, attrLength) : (attrName.equals("EnclosingMethod") ? new EnclosingMethodAttrInfo(cf, attrNameIndex, attrLength) : (attrName.equals("StackMapTable") ? new StackMapTableAttrInfo(cf, attrNameIndex, attrLength) : (attrName.equals("BootstrapMethods") ? new BootstrapMethodsAttrInfo(cf, attrNameIndex, attrLength) : new AttrInfo(cf, attrNameIndex, attrLength)))))))))))))))))));
        ai.source = source;
        ai.readInfo(din);
        return ai;
    }

    protected AttrInfo(ClassFile cf, int attrNameIndex, int attrLength) {
        this.cf = cf;
        this.u2attrNameIndex = attrNameIndex;
        this.u4attrLength = attrLength;
    }

    protected int getAttrInfoLength() {
        return this.u4attrLength;
    }

    protected String getAttrName() {
        return "Unknown";
    }

    protected void trimAttrsExcept(List<String> keepAttrs) {
    }

    protected void markUtf8Refs(ConstantPool pool) throws ClassFileException {
        pool.incRefCount(this.u2attrNameIndex);
        this.markUtf8RefsInInfo(pool);
    }

    protected void markUtf8RefsInInfo(ConstantPool pool) throws ClassFileException {
    }

    protected void readInfo(DataInput din) throws IOException, ClassFileException {
        this.info = new byte[this.u4attrLength];
        din.readFully(this.info);
    }

    public void write(DataOutput dout) throws IOException, ClassFileException {
        if (dout == null) {
            throw new IOException("No output stream was provided.");
        }
        dout.writeShort(this.u2attrNameIndex);
        dout.writeInt(this.getAttrInfoLength());
        this.writeInfo(dout);
    }

    public void writeInfo(DataOutput dout) throws IOException, ClassFileException {
        dout.write(this.info);
    }

    protected void remap(ClassFile cf, NameMapper nm) throws ClassFileException {
    }
}

