/*
 * Decompiled with CFR 0.152.
 */
package com.rl.obf.classfile;

import com.rl.obf.classfile.AttrInfo;
import com.rl.obf.classfile.ClassConstants;
import com.rl.obf.classfile.ClassCpInfo;
import com.rl.obf.classfile.ClassFile;
import com.rl.obf.classfile.ClassFileException;
import com.rl.obf.classfile.ConstantPool;
import com.rl.obf.classfile.CpInfo;
import com.rl.obf.classfile.ExceptionInfo;
import com.rl.obf.classfile.FlagHashtable;
import com.rl.obf.classfile.MethodrefCpInfo;
import com.rl.obf.classfile.NameAndTypeCpInfo;
import com.rl.obf.classfile.NameMapper;
import com.rl.obf.classfile.StringCpInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CodeAttrInfo
extends AttrInfo {
    public static final int CONSTANT_FIELD_SIZE = 12;
    private int u2maxStack;
    private int u2maxLocals;
    private int u4codeLength;
    private byte[] code;
    private List<ExceptionInfo> exceptionTable;
    protected List<AttrInfo> attributes;

    private static int opcodeBytes(int opcode) {
        switch (opcode) {
            case 170: 
            case 171: 
            case 196: {
                return -1;
            }
            case 16: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 188: {
                return 1;
            }
            case 17: 
            case 19: 
            case 20: 
            case 132: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 187: 
            case 189: 
            case 192: 
            case 193: 
            case 198: 
            case 199: {
                return 2;
            }
            case 197: {
                return 3;
            }
            case 185: 
            case 186: 
            case 200: 
            case 201: {
                return 4;
            }
        }
        return 0;
    }

    protected CodeAttrInfo(ClassFile cf, int attrNameIndex, int attrLength) {
        super(cf, attrNameIndex, attrLength);
    }

    @Override
    protected int getAttrInfoLength() {
        int length = 12 + this.u4codeLength + this.exceptionTable.size() * 8;
        for (AttrInfo at : this.attributes) {
            length += 6 + at.getAttrInfoLength();
        }
        return length;
    }

    @Override
    protected String getAttrName() {
        return "Code";
    }

    @Override
    protected void trimAttrsExcept(List<String> keepAttrs) {
        ArrayList<AttrInfo> delAttrs = new ArrayList<AttrInfo>();
        for (AttrInfo at : this.attributes) {
            if (keepAttrs.contains(at.getAttrName())) {
                at.trimAttrsExcept(keepAttrs);
                continue;
            }
            delAttrs.add(at);
        }
        this.attributes.removeAll(delAttrs);
    }

    @Override
    protected void markUtf8RefsInInfo(ConstantPool pool) throws ClassFileException {
        for (AttrInfo at : this.attributes) {
            at.markUtf8Refs(pool);
        }
    }

    @Override
    protected void readInfo(DataInput din) throws IOException, ClassFileException {
        this.u2maxStack = din.readUnsignedShort();
        this.u2maxLocals = din.readUnsignedShort();
        this.u4codeLength = din.readInt();
        this.code = new byte[this.u4codeLength];
        din.readFully(this.code);
        int u2exceptionTableLength = din.readUnsignedShort();
        this.exceptionTable = new ArrayList<ExceptionInfo>(u2exceptionTableLength);
        for (int i = 0; i < u2exceptionTableLength; ++i) {
            this.exceptionTable.add(ExceptionInfo.create(din));
        }
        int u2attributesCount = din.readUnsignedShort();
        this.attributes = new ArrayList<AttrInfo>(u2attributesCount);
        for (int i = 0; i < u2attributesCount; ++i) {
            this.attributes.add(AttrInfo.create(din, this.cf, ClassConstants.AttrSource.CODE));
        }
    }

    @Override
    public void writeInfo(DataOutput dout) throws IOException, ClassFileException {
        dout.writeShort(this.u2maxStack);
        dout.writeShort(this.u2maxLocals);
        dout.writeInt(this.u4codeLength);
        dout.write(this.code);
        dout.writeShort(this.exceptionTable.size());
        for (ExceptionInfo ex : this.exceptionTable) {
            ex.write(dout);
        }
        dout.writeShort(this.attributes.size());
        for (AttrInfo at : this.attributes) {
            at.write(dout);
        }
    }

    @Override
    protected void remap(ClassFile cf, NameMapper nm) throws ClassFileException {
        for (AttrInfo at : this.attributes) {
            at.remap(cf, nm);
        }
    }

    protected FlagHashtable walkFindClassStrings(FlagHashtable cpToFlag) throws ClassFileException {
        return this.walkClassStrings(cpToFlag, Collections.emptyMap());
    }

    protected void walkUpdateClassStrings(Map<Integer, ?> cpUpdate) throws ClassFileException {
        this.walkClassStrings(null, cpUpdate);
    }

    private FlagHashtable walkClassStrings(FlagHashtable cpToFlag, Map<Integer, ?> cpUpdate) throws ClassFileException {
        int opcodePrev = -1;
        int ldcIndex = -1;
        for (int i = 0; i < this.code.length; ++i) {
            CpInfo ldcCpInfo;
            int opcode = this.code[i] & 0xFF;
            if (opcode == 18 && i + 1 < this.code.length) {
                ldcIndex = this.code[i + 1] & 0xFF;
                CpInfo ldcCpInfo2 = this.cf.getCpEntry(ldcIndex);
                if (!(ldcCpInfo2 instanceof StringCpInfo)) {
                    ldcIndex = -1;
                }
            } else if (opcode == 19 && i + 2 < this.code.length && !((ldcCpInfo = this.cf.getCpEntry(ldcIndex = ((this.code[i + 1] & 0xFF) << 8) + (this.code[i + 2] & 0xFF))) instanceof StringCpInfo)) {
                ldcIndex = -1;
            }
            if ((opcodePrev == 18 || opcodePrev == 19) && ldcIndex != -1) {
                int invokeIndex;
                CpInfo cpInfo;
                boolean isClassForName = false;
                if (opcode == 184 && i + 2 < this.code.length && (cpInfo = this.cf.getCpEntry(invokeIndex = ((this.code[i + 1] & 0xFF) << 8) + (this.code[i + 2] & 0xFF))) instanceof MethodrefCpInfo) {
                    MethodrefCpInfo entry = (MethodrefCpInfo)cpInfo;
                    ClassCpInfo classEntry = (ClassCpInfo)this.cf.getCpEntry(entry.getClassIndex());
                    String className = this.cf.getUtf8(classEntry.getNameIndex());
                    NameAndTypeCpInfo ntEntry = (NameAndTypeCpInfo)this.cf.getCpEntry(entry.getNameAndTypeIndex());
                    String name = this.cf.getUtf8(ntEntry.getNameIndex());
                    String descriptor = this.cf.getUtf8(ntEntry.getDescriptorIndex());
                    if ("class$".equals(name) && ("(Ljava/lang/String;)Ljava/lang/Class;".equals(descriptor) || "(Ljava/lang/String;Z)Ljava/lang/Class;".equals(descriptor)) || "java/lang/Class".equals(className) && "forName".equals(name) && "(Ljava/lang/String;)Ljava/lang/Class;".equals(descriptor)) {
                        isClassForName = true;
                        Object o = cpUpdate.get(new Integer(ldcIndex));
                        if (o instanceof Integer) {
                            Integer oi = (Integer)o;
                            int remapStringIndex = oi;
                            switch (opcodePrev) {
                                case 19: {
                                    this.code[i - 2] = 0;
                                }
                                case 18: {
                                    this.code[i - 1] = (byte)remapStringIndex;
                                    break;
                                }
                                default: {
                                    throw new RuntimeException("Internal error: .class or Class.forName remap of non-ldc/ldc_w");
                                }
                            }
                        }
                    }
                }
                if (cpToFlag != null) {
                    cpToFlag.updateFlag(this.cf.getCpEntry(ldcIndex), ldcIndex, isClassForName);
                }
            }
            int bytes = this.getOpcodeBytes(opcode, i);
            i += bytes;
            opcodePrev = opcode;
        }
        return cpToFlag;
    }

    private int getOpcodeBytes(int opcode, int i) throws ClassFileException {
        int bytes = CodeAttrInfo.opcodeBytes(opcode);
        if (bytes < 0) {
            block0 : switch (opcode) {
                case 170: {
                    bytes = 3 - i % 4;
                    int low = ((this.code[i + 1 + (bytes += 4)] & 0xFF) << 24) + ((this.code[i + 1 + bytes + 1] & 0xFF) << 16) + ((this.code[i + 1 + bytes + 2] & 0xFF) << 8) + (this.code[i + 1 + bytes + 3] & 0xFF);
                    int high = ((this.code[i + 1 + (bytes += 4)] & 0xFF) << 24) + ((this.code[i + 1 + bytes + 1] & 0xFF) << 16) + ((this.code[i + 1 + bytes + 2] & 0xFF) << 8) + (this.code[i + 1 + bytes + 3] & 0xFF);
                    bytes += 4;
                    if (high < low) break;
                    bytes += (high - low + 1) * 4;
                    break;
                }
                case 171: {
                    bytes = 3 - i % 4;
                    int npairs = ((this.code[i + 1 + (bytes += 4)] & 0xFF) << 24) + ((this.code[i + 1 + bytes + 1] & 0xFF) << 16) + ((this.code[i + 1 + bytes + 2] & 0xFF) << 8) + (this.code[i + 1 + bytes + 3] & 0xFF);
                    bytes += 4;
                    if (npairs < 0) break;
                    bytes += npairs * 8;
                    break;
                }
                case 196: {
                    int wideOpcode = this.code[i + 1] & 0xFF;
                    switch (wideOpcode) {
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 169: {
                            bytes = 3;
                            break block0;
                        }
                        case 132: {
                            bytes = 5;
                            break block0;
                        }
                    }
                    throw new ClassFileException("Illegal wide opcode");
                }
                default: {
                    throw new ClassFileException("Illegal variable length opcode");
                }
            }
        }
        return bytes;
    }
}

