/*
 * Decompiled with CFR 0.152.
 */
package de.oceanlabs.mcp.mcinjector.adaptors;

import de.oceanlabs.mcp.mcinjector.MCInjectorImpl;
import de.oceanlabs.mcp.mcinjector.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;

public class ApplyMap
extends ClassVisitor {
    private static final Logger log = Logger.getLogger("MCInjector");
    private MCInjectorImpl mci;
    String className;

    public ApplyMap(ClassVisitor cn, MCInjectorImpl mci) {
        super(327680, cn);
        this.mci = mci;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (!this.mci.generate) {
            log.log(Level.FINE, "Class: " + name + " Extends: " + superName);
        }
        this.className = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (name.equals("<clinit>")) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        if (!this.mci.generate) {
            log.log(Level.FINER, "  Name: " + name + " Desc: " + desc + " Sig: " + signature);
        }
        final String clsSig = this.className + "." + name + desc;
        exceptions = this.processExceptions(clsSig, exceptions);
        if ((access & 0x400) != 0 || (access & 0x100) != 0) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        MethodNode mn = (MethodNode)this.cv.visitMethod(access, name, desc, signature, exceptions);
        return new MethodVisitor(this.api, mn){

            @Override
            public void visitEnd() {
                super.visitEnd();
                ApplyMap.this.processLVT(ApplyMap.this.className, clsSig, MCInjectorImpl.getMethodNode(this.mv));
            }
        };
    }

    private String[] processExceptions(String clsSig, String[] exceptions) {
        List<String> map = this.mci.getExceptions(clsSig);
        if (exceptions != null) {
            for (String s : exceptions) {
                if (map.contains(s)) continue;
                map.add(s);
            }
        }
        if (map.size() > 0) {
            String excs = StringUtil.joinString(map, ",");
            exceptions = map.toArray(new String[map.size()]);
            log.log(Level.FINE, "    Adding Exceptions: " + excs);
            this.mci.setExceptions(clsSig, excs);
        }
        return exceptions;
    }

    private MethodNode processLVT(String clsName, String classSig, MethodNode mn) {
        List<String> params = this.mci.getParams(classSig);
        if (params.size() == 0) {
            return mn;
        }
        ArrayList<Type> types = new ArrayList<Type>();
        if ((mn.access & 8) == 0) {
            types.add(Type.getType("L" + clsName + ";"));
            params.add(0, "this");
        }
        types.addAll(Arrays.asList(Type.getArgumentTypes(mn.desc)));
        if (types.size() == 0) {
            return mn;
        }
        log.fine("    Applying map:");
        if (params.size() != types.size()) {
            log.log(Level.SEVERE, "    Incorrect argument count: " + types.size() + " -> " + params.size());
            throw new RuntimeException("Incorrect argument count: " + types.size() + " -> " + params.size());
        }
        AbstractInsnNode tmp = mn.instructions.getFirst();
        if (tmp == null) {
            mn.instructions.add(new LabelNode());
        } else if (tmp.getType() != 8) {
            mn.instructions.insertBefore(tmp, new LabelNode());
        }
        tmp = mn.instructions.getLast();
        if (tmp == null) {
            mn.instructions.add(new LabelNode());
        } else if (tmp.getType() != 8) {
            mn.instructions.insert(tmp, new LabelNode());
        }
        HashMap<Integer, String> parNames = new HashMap<Integer, String>();
        int x = 0;
        int y = 0;
        while (x < params.size()) {
            String arg = params.get(x);
            String desc = ((Type)types.get(x)).getDescriptor();
            parNames.put(y, arg);
            if (desc.equals("J") || desc.equals("D")) {
                ++y;
            }
            ++x;
            ++y;
        }
        LabelNode start = (LabelNode)mn.instructions.getFirst();
        LabelNode end = (LabelNode)mn.instructions.getLast();
        HashSet<Integer> found = new HashSet<Integer>();
        if (mn.localVariables == null) {
            mn.localVariables = new ArrayList<LocalVariableNode>();
        }
        for (LocalVariableNode lvn : mn.localVariables) {
            String name = (String)parNames.get(lvn.index);
            if (name == null) continue;
            log.fine("      ReNaming argument (" + lvn.index + "): " + lvn.name + " -> " + name);
            lvn.name = name;
            found.add(lvn.index);
        }
        int x2 = 0;
        int y2 = 0;
        while (x2 < params.size()) {
            String arg = params.get(x2);
            String desc = ((Type)types.get(x2)).getDescriptor();
            if (!found.contains(y2)) {
                log.fine("      Naming argument " + x2 + " (" + y2 + ") -> " + arg + " " + desc);
                mn.localVariables.add(new LocalVariableNode(arg, desc, null, start, end, y2));
                if (desc.equals("J") || desc.equals("D")) {
                    ++y2;
                }
            }
            ++x2;
            ++y2;
        }
        Collections.sort(mn.localVariables, new Comparator<LocalVariableNode>(){

            @Override
            public int compare(LocalVariableNode o1, LocalVariableNode o2) {
                return o1.index < o2.index ? -1 : (o1.index == o2.index ? 0 : 1);
            }
        });
        return mn;
    }
}

