/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.jetbrains.java.decompiler.main.TextBuffer;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class SwitchExprent
extends Exprent {
    private Exprent value;
    private List<List<Exprent>> caseValues = new ArrayList<List<Exprent>>();

    public SwitchExprent(Exprent value, BitSet bytecodeOffsets) {
        super(11);
        this.value = value;
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    @Override
    public Exprent copy() {
        SwitchExprent swExpr = new SwitchExprent(this.value.copy(), this.bytecode);
        ArrayList<List<Exprent>> lstCaseValues = new ArrayList<List<Exprent>>();
        for (List<Exprent> lst : this.caseValues) {
            lstCaseValues.add(new ArrayList<Exprent>(lst));
        }
        swExpr.setCaseValues(lstCaseValues);
        return swExpr;
    }

    @Override
    public VarType getExprType() {
        return this.value.getExprType();
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        CheckTypesResult result = new CheckTypesResult();
        result.addMinTypeExprent(this.value, VarType.VARTYPE_BYTECHAR);
        result.addMaxTypeExprent(this.value, VarType.VARTYPE_INT);
        VarType valType = this.value.getExprType();
        for (List<Exprent> lst : this.caseValues) {
            for (Exprent expr : lst) {
                VarType caseType;
                if (expr == null || (caseType = expr.getExprType()).equals(valType)) continue;
                valType = VarType.getCommonSupertype(caseType, valType);
                result.addMinTypeExprent(this.value, valType);
            }
        }
        return result;
    }

    @Override
    public List<Exprent> getAllExprents() {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        lst.add(this.value);
        return lst;
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        tracer.addMapping(this.bytecode);
        return this.value.toJava(indent, tracer).enclose("switch(", ")");
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        if (oldExpr == this.value) {
            this.value = newExpr;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof SwitchExprent)) {
            return false;
        }
        SwitchExprent sw = (SwitchExprent)o;
        return InterpreterUtil.equalObjects(this.value, sw.getValue());
    }

    @Override
    public void getBytecodeRange(BitSet values) {
        if (this.caseValues != null && !this.caseValues.isEmpty()) {
            for (List<Exprent> l : this.caseValues) {
                if (l == null || l.isEmpty()) continue;
                for (Exprent e : l) {
                    if (e == null) continue;
                    e.getBytecodeRange(values);
                }
            }
        }
        SwitchExprent.measureBytecode(values, this.value);
        this.measureBytecode(values);
    }

    public Exprent getValue() {
        return this.value;
    }

    public void setCaseValues(List<List<Exprent>> caseValues) {
        this.caseValues = caseValues;
    }
}

