/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.gen.generics;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericClassDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericFieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericType;

public class GenericMain {
    private static final String[] typeNames = new String[]{"byte", "char", "double", "float", "int", "long", "short", "boolean"};

    public static GenericClassDescriptor parseClassSignature(String qualifiedName, String signature) {
        String original = signature;
        try {
            GenericClassDescriptor descriptor = new GenericClassDescriptor();
            signature = GenericMain.parseFormalParameters(signature, descriptor.fparameters, descriptor.fbounds);
            String superCl = GenericType.getNextType(signature);
            descriptor.superclass = GenericType.parse(superCl);
            signature = signature.substring(superCl.length());
            while (signature.length() > 0) {
                String superIf = GenericType.getNextType(signature);
                descriptor.superinterfaces.add(GenericType.parse(superIf));
                signature = signature.substring(superIf.length());
            }
            StringBuilder buf = new StringBuilder();
            buf.append('L').append(qualifiedName).append('<');
            for (String t : descriptor.fparameters) {
                buf.append('T').append(t).append(';');
            }
            buf.append(">;");
            descriptor.genericType = (GenericType)GenericType.parse(buf.toString());
            return descriptor;
        }
        catch (RuntimeException e) {
            DecompilerContext.getLogger().writeMessage("Invalid signature: " + original, IFernflowerLogger.Severity.WARN);
            return null;
        }
    }

    public static GenericFieldDescriptor parseFieldSignature(String signature) {
        try {
            GenericFieldDescriptor descriptor = new GenericFieldDescriptor();
            descriptor.type = GenericType.parse(signature);
            return descriptor;
        }
        catch (RuntimeException e) {
            DecompilerContext.getLogger().writeMessage("Invalid signature: " + signature, IFernflowerLogger.Severity.WARN);
            return null;
        }
    }

    public static GenericMethodDescriptor parseMethodSignature(String signature) {
        String original = signature;
        try {
            String par;
            GenericMethodDescriptor descriptor = new GenericMethodDescriptor();
            signature = GenericMain.parseFormalParameters(signature, descriptor.fparameters, descriptor.fbounds);
            int to = signature.indexOf(")");
            String pars = signature.substring(1, to);
            signature = signature.substring(to + 1);
            while (pars.length() > 0) {
                par = GenericType.getNextType(pars);
                descriptor.params.add(GenericType.parse(par));
                pars = pars.substring(par.length());
            }
            par = GenericType.getNextType(signature);
            descriptor.ret = GenericType.parse(par);
            if ((signature = signature.substring(par.length())).length() > 0) {
                String[] exceptions = signature.split("\\^");
                for (int i = 1; i < exceptions.length; ++i) {
                    descriptor.exceptions.add(GenericType.parse(exceptions[i]));
                }
            }
            return descriptor;
        }
        catch (RuntimeException e) {
            DecompilerContext.getLogger().writeMessage("Invalid signature: " + original, IFernflowerLogger.Severity.WARN);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String parseFormalParameters(String signature, List<String> parameters, List<List<VarType>> bounds) {
        int index;
        if (signature.charAt(0) != '<') {
            return signature;
        }
        int counter = 1;
        block4: for (index = 1; index < signature.length(); ++index) {
            switch (signature.charAt(index)) {
                case '<': {
                    ++counter;
                    break;
                }
                case '>': {
                    if (--counter == 0) break block4;
                }
            }
        }
        String value = signature.substring(1, index);
        signature = signature.substring(index + 1);
        while (value.length() > 0) {
            int to = value.indexOf(":");
            String param = value.substring(0, to);
            value = value.substring(to + 1);
            ArrayList<VarType> lstBounds = new ArrayList<VarType>();
            while (true) {
                if (value.charAt(0) == ':') {
                    value = value.substring(1);
                }
                String bound = GenericType.getNextType(value);
                lstBounds.add(GenericType.parse(bound));
                value = value.substring(bound.length());
                if (value.length() == 0 || value.charAt(0) != ':') break;
                value = value.substring(1);
            }
            parameters.add(param);
            bounds.add(lstBounds);
        }
        return signature;
    }

    public static String getGenericCastTypeName(GenericType type) {
        String s = GenericMain.getTypeName(type);
        int dim = type.arrayDim;
        while (dim-- > 0) {
            s = s + "[]";
        }
        return s;
    }

    private static String getTypeName(GenericType type) {
        int tp = type.type;
        if (tp <= 7) {
            return typeNames[tp];
        }
        if (tp == 10) {
            return "void";
        }
        if (tp == 18) {
            return type.value;
        }
        if (tp == 8) {
            return type.getCastName();
        }
        throw new RuntimeException("Invalid type: " + type);
    }
}

