/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.gen.generics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMain;

public class GenericType
extends VarType {
    public static final int WILDCARD_EXTENDS = 1;
    public static final int WILDCARD_SUPER = 2;
    public static final int WILDCARD_UNBOUND = 3;
    public static final int WILDCARD_NO = 4;
    private final VarType parent;
    private final List<VarType> arguments;
    private final int wildcard;

    public GenericType(int type, int arrayDim, String value, VarType parent, List<VarType> arguments, int wildcard) {
        super(type, arrayDim, value, GenericType.getFamily(type, arrayDim), GenericType.getStackSize(type, arrayDim), false);
        this.parent = parent;
        this.arguments = arguments == null ? Collections.emptyList() : arguments;
        this.wildcard = wildcard;
    }

    public static VarType parse(String signature) {
        return GenericType.parse(signature, 4);
    }

    public static VarType parse(String signature, int wildcard) {
        int type = 0;
        int arrayDim = 0;
        String value = null;
        List<VarType> params = null;
        VarType parent = null;
        block5: for (int index = 0; index < signature.length(); ++index) {
            switch (signature.charAt(index)) {
                case '[': {
                    ++arrayDim;
                    continue block5;
                }
                case 'T': {
                    type = 18;
                    value = signature.substring(index + 1, signature.length() - 1);
                    break block5;
                }
                case 'L': {
                    type = 8;
                    signature = signature.substring(index + 1, signature.length() - 1);
                    String cl = GenericType.getNextClassSignature(signature);
                    if (cl.length() == signature.length()) {
                        int argStart = cl.indexOf(60);
                        if (argStart >= 0) {
                            value = cl.substring(0, argStart);
                            params = GenericType.parseArgumentsList(cl.substring(argStart + 1, cl.length() - 1));
                            break block5;
                        }
                        value = cl;
                        break block5;
                    }
                    StringBuilder name_buff = new StringBuilder();
                    while (signature.length() > 0) {
                        String name = cl;
                        String args = null;
                        int argStart = cl.indexOf(60);
                        if (argStart >= 0) {
                            name = cl.substring(0, argStart);
                            args = cl.substring(argStart + 1, cl.length() - 1);
                        }
                        if (name_buff.length() > 0) {
                            name_buff.append('$');
                        }
                        name_buff.append(name);
                        value = name_buff.toString();
                        List<VarType> list = params = args == null ? null : GenericType.parseArgumentsList(args);
                        if (cl.length() == signature.length()) break block5;
                        parent = parent == null && params == null ? GenericType.parse("L" + value + ";") : new GenericType(8, 0, value, parent, params, wildcard);
                        signature = signature.substring(cl.length() + 1);
                        cl = GenericType.getNextClassSignature(signature);
                    }
                    break block5;
                }
                default: {
                    value = signature.substring(index, index + 1);
                    type = VarType.getType(value.charAt(0));
                }
            }
        }
        if (type == 18) {
            return new GenericType(type, arrayDim, value, null, null, wildcard);
        }
        if (type == 8) {
            if (parent == null && params == null && wildcard == 4) {
                return new VarType(type, arrayDim, value);
            }
            return new GenericType(type, arrayDim, value, parent, params, wildcard);
        }
        return new VarType(type, arrayDim, value);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String getNextClassSignature(String value) {
        int counter = 0;
        int index = 0;
        while (index < value.length()) {
            switch (value.charAt(index)) {
                case '<': {
                    ++counter;
                    break;
                }
                case '>': {
                    --counter;
                    break;
                }
                case '.': {
                    if (counter != 0) break;
                    return value.substring(0, index);
                }
            }
            ++index;
        }
        return value.substring(0, index);
    }

    private static List<VarType> parseArgumentsList(String value) {
        if (value == null) {
            return null;
        }
        ArrayList<VarType> args = new ArrayList<VarType>();
        while (value.length() > 0) {
            String typeStr = GenericType.getNextType(value);
            int len = typeStr.length();
            int wildcard = 4;
            switch (typeStr.charAt(0)) {
                case '*': {
                    wildcard = 3;
                    break;
                }
                case '+': {
                    wildcard = 1;
                    break;
                }
                case '-': {
                    wildcard = 2;
                }
            }
            if (wildcard != 4) {
                typeStr = typeStr.substring(1);
            }
            args.add(typeStr.length() == 0 ? null : GenericType.parse(typeStr, wildcard));
            value = value.substring(len);
        }
        return args;
    }

    public static String getNextType(String value) {
        int index;
        int counter = 0;
        boolean contMode = false;
        block8: for (index = 0; index < value.length(); ++index) {
            switch (value.charAt(index)) {
                case '*': {
                    if (contMode) continue block8;
                    break block8;
                }
                case 'L': 
                case 'T': {
                    if (!contMode) {
                        contMode = true;
                    }
                }
                case '+': 
                case '-': 
                case '[': {
                    continue block8;
                }
                default: {
                    if (contMode) continue block8;
                    break block8;
                }
                case '<': {
                    ++counter;
                    continue block8;
                }
                case '>': {
                    --counter;
                    continue block8;
                }
                case ';': {
                    if (counter == 0) break block8;
                }
            }
        }
        return value.substring(0, index + 1);
    }

    @Override
    public GenericType decreaseArrayDim() {
        assert (this.arrayDim > 0) : this;
        return new GenericType(this.type, this.arrayDim - 1, this.value, this.parent, this.arguments, this.wildcard);
    }

    @Override
    public VarType resizeArrayDim(int newArrayDim) {
        return new GenericType(this.type, newArrayDim, this.value, this.parent, this.arguments, this.wildcard);
    }

    public VarType getParent() {
        return this.parent;
    }

    public List<VarType> getArguments() {
        return this.arguments;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    public int getWildcard() {
        return this.wildcard;
    }

    public String getCastName() {
        String clsName = null;
        clsName = this.parent == null ? DecompilerContext.getImportCollector().getShortName(this.value.replace('/', '.')) : (this.parent.isGeneric() ? ((GenericType)this.parent).getCastName() + "." + this.value.substring(this.parent.value.length() + 1) : DecompilerContext.getImportCollector().getShortName(this.parent.value.replace('/', '.')) + "." + this.value.substring(this.value.lastIndexOf(46) + 1));
        return clsName + this.getTypeArguments();
    }

    private String getTypeArguments() {
        StringBuilder buffer = new StringBuilder();
        if (!this.arguments.isEmpty()) {
            buffer.append('<');
            for (int i = 0; i < this.arguments.size(); ++i) {
                VarType par;
                if (i > 0) {
                    buffer.append(", ");
                }
                if ((par = this.arguments.get(i)) == null) {
                    buffer.append('?');
                    continue;
                }
                if (par.isGeneric()) {
                    GenericType gen = (GenericType)par;
                    switch (gen.getWildcard()) {
                        case 1: {
                            buffer.append("? extends ");
                            break;
                        }
                        case 2: {
                            buffer.append("? super ");
                        }
                    }
                    buffer.append(GenericMain.getGenericCastTypeName(gen));
                    continue;
                }
                buffer.append(ExprProcessor.getCastTypeName(par));
            }
            buffer.append(">");
        }
        return buffer.toString();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        switch (this.getWildcard()) {
            case 1: {
                buf.append("? extends ");
                break;
            }
            case 2: {
                buf.append("? super ");
            }
        }
        buf.append(super.toString());
        buf.append(this.getTypeArguments());
        return buf.toString();
    }

    @Override
    public VarType remap(Map<VarType, VarType> map) {
        VarType main = super.remap(map);
        if (main != this) {
            return main;
        }
        boolean changed = false;
        VarType parent = this.getParent();
        if (map.containsKey(parent)) {
            parent = map.get(parent);
            changed = true;
        }
        ArrayList<VarType> newArgs = new ArrayList<VarType>();
        for (VarType arg : this.getArguments()) {
            VarType newArg = null;
            if (arg != null) {
                newArg = arg.remap(map);
            }
            if (newArg != arg) {
                newArgs.add(newArg);
                changed = true;
                continue;
            }
            newArgs.add(arg);
        }
        if (changed) {
            return new GenericType(main.type, main.arrayDim, main.value, parent, newArgs, this.getWildcard());
        }
        return this;
    }
}

